% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/msltrend.R
\name{msl.plot}
\alias{msl.plot}
\title{Screen plotting options.}
\usage{
msl.plot(x, type = 1, ci = 1)
}
\arguments{
\item{x}{object of class \dQuote{msl.trend} (see \code{\link{msl.trend}} and
\code{\link{s}}) or \dQuote{msl.forecast} (see \code{\link{msl.forecast}} and
\code{\link{t}}).}

\item{type}{numeric, enables a user defined input to select the type of chart
to be plotted. The default setting (type = 1) provides 3 charts in the same
plot area with the time series in the top panel, instantaneous velocity in
the middle panel and instantaneous acceleration in the bottom panel. The
alternatives (2, 3 and 4) are single panel plots of time series, instantaneous
velocity and instantaneous acceleration, respectively.}

\item{ci}{numeric, enables a user defined input to select the type of
confidence interval to be displayed on the plots. The default setting (ci = 1)
corresponds to a 95\% confidence interval whilst ci=2 provides a 99\%
confidence interval.}
}
\description{
Screen plotting options.
}
\details{
This routine provides a range of screen plotting options for both
\dQuote{msl.trend} (see \code{\link{msl.trend}}) and \dQuote{msl.forecast}
(see \code{\link{msl.forecast}}) objects. The same range of alternative pdf
plotting options are available via \code{\link{msl.pdf}}.
}
\examples{
# -------------------------------------------------------------------------
# Isolate trend from Baltimore record, filling gaps with spline interpolation,
# 500 iterations and adding 1000 mm of slr to 2100. Use raw 'Balt.csv' data file.
# Note: ordinarily user would call 'File.csv' direct from working directory
# using the following sample code:
# s <- msl.trend('Balt.csv', fillgaps = 3, iter = 500, 'BALTIMORE, USA')
# t <- msl.forecast(s, slr = 1000)
# -------------------------------------------------------------------------

data(s) # msl.trend object from above-mentioned example
data(t) # msl.forecast object from above-mentioned example
msl.plot(s) # default screen plot output, 3 panels, 95\% confidence intervals
msl.plot(s, type = 2) # plot time series, 95\% confidence intervals
msl.plot(s, type = 3) # plot instantaneous velocity, 95\% confidence intervals
msl.plot(s, type = 4, ci = 2) # plot acceleration, 99\% confidence intervals
msl.plot(t) # default screen plot output, 3 panels, 95\% confidence intervals
msl.plot(t, type = 2) # plot time series, 95\% confidence intervals
msl.plot(t, type = 3) # plot instantaneous velocity, 95\% confidence intervals
msl.plot(t, type = 4, ci = 2) # plot acceleration, 99\% confidence intervals

}
\seealso{
\code{\link{msl.trend}}, \code{\link{msl.forecast}},
\code{\link{msl.pdf}}, \code{\link{Balt}}, \code{\link{s}}, \code{\link{t}}
}

