% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/msltrend.R
\name{msl.forecast}
\alias{msl.forecast}
\title{Projected sea level rise integrated with historical record.}
\usage{
msl.forecast(object, slr = 800, plot = TRUE)
}
\arguments{
\item{object}{of class \dQuote{msl.trend} (see \code{\link{msl.trend}} and
\code{\link{s}}).}

\item{slr}{numeric, enables a user defined amount of projected sea level
rise in millimetres. The user range is [200 to 1500] where 800 is the
default setting.}

\item{plot}{logical, if \sQuote{TRUE} then the original time series is
plotted to the screen along with the trend component, the result of gap
filling (where necessary) and the added quantum of sea level rise
selected. 95\% confidence intervals have also been applied. Default = TRUE.}
}
\value{
An object of class \dQuote{msl.forecast} is returned with the
following elements:
\describe{
 \item{\strong{$Station.Name: }}{the name of the data record.}
 \item{\strong{$Summary: }}{a summary data frame of relevant attributes
 relating to the trend and the inputted annual average data set extended
 to 2100 with projected sea level rise, including:}
 \itemize{
  \item{$Year: input data; }
  \item{$MSL: input data; }
  \item{$Trend: mean sea level trend; }
  \item{$TrendSD: standard deviation of the determined mean sea level
  trend; }
  \item{$Vel: velocity (or first derivative) of mean sea level trend
  (mm/year); }
  \item{$VelSD: standard deviation of the velocity of the mean sea level
  trend; }
  \item{$Acc: acceleration (or second derivative) of mean sea level trend
  (mm/year/year); }
  \item{$AccSD: standard deviation of the acceleration of the mean sea
  level trend; and }
  \item{$FilledTS: gap-filled time series (where necessary). }
   }
}

\describe{
 \item{\strong{$Velocity: }}{outputs the peak velocity and the year in
 which it occurs.}
 \item{\strong{$Acceleration: }}{outputs the peak acceleration and the
 year in which it occurs.}
 \item{\strong{$Historical.Record: }}{outputs details of the start, end
 and length of the input data set.}
 \item{\strong{$Historical.Fillgaps: }}{outputs the extent of missing data
 (years) in the original record and the gap filling method used (where
 necessary).}
 \item{\strong{$Projected.SLR: }}{details the amount of sea level rise
 applied between the end of the historical record and the year 2100.}
 \item{\strong{$Bootstrapping.Iterations: }}{outputs the number of
 iterations used to generate the respective standard deviations for error
 margins.}
 }
}
\description{
Projected sea level rise integrated with historical record.
}
\details{
This routine adds a user specified quantum of sea level rise
from the end of the deconstructed historical record to the year 2100.
All internal parameters captured in the \code{\link{msl.trend}} object
are passed directly to \code{\link{msl.forecast}}.
}
\examples{
# -------------------------------------------------------------------------
# Isolate trend from Baltimore record, filling gaps with spline interpolation,
# 500 iterations and adding 1000 mm of slr to 2100. Use raw 'Balt.csv' data file.
# Note: ordinarily user would call 'File.csv' direct from working directory
# using the following sample code:
# s <- msl.trend('Balt.csv', fillgaps = 3, iter = 500, 'BALTIMORE, USA')
# t <- msl.forecast(s, slr = 1000)
# -------------------------------------------------------------------------

data(s) # msl.trend object from above-mentioned example
data(t) # msl.forecast object from above-mentioned example
str(t) # check structure of msl.forecast object
msl.plot(s, type=2) # check screen output of gapfilling and trend estimate
msl.plot(t, type=2) # check screen output of adding 1000 mm of sea level rise

}
\seealso{
\code{\link{msl.trend}}, \code{\link{msl.plot}}, \code{\link{msl.pdf}},
\code{\link{summary}}, \code{\link{Balt}}, \code{\link{s}}, \code{\link{t}}.
}

