% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modlib.R
\name{modlib}
\alias{modlib}
\title{Internal model library}
\usage{
modlib(model = NULL, ..., list = FALSE)
}
\arguments{
\item{model}{\code{character} name of a model in the library.}

\item{...}{passed to \code{\link[=mread_cache]{mread_cache()}}.}

\item{list}{logical; if \code{TRUE}, a list of available models is returned.}
}
\description{
Pre-coded models are included in the mrgsolve installation; these can be
compiled and loaded with \code{modlib()}. These models are usually most useful
for exploratory simulation or learning mrgsolve. Production simulation work
is typically accomplished by a custom-coded model.
}
\details{
See \link{modlib_details}, \link{modlib_pk}, \link{modlib_pkpd}, \link{modlib_tmdd},
\link{modlib_viral} for details.

Call \code{modlib("<modelname>")} to compile and load a mode from the
library.

Call \code{modlib(list=TRUE)} to list available models.  Once the model
is loaded (see examples below), call \code{as.list(mod)$code} to extract
model code and equations.
}
\examples{
\dontrun{
mod <- mread("pk1cmt", modlib())
mod <- mread("pk2cmt", modlib()) 
mod <- mread("pk3cmt", modlib()) 
mod <- mread("pk1",    modlib())
mod <- mread("pk2",    modlib())
mod <- mread("popex",  modlib())
mod <- mread("irm1",   modlib()) 
mod <- mread("irm2",   modlib()) 
mod <- mread("irm3",   modlib()) 
mod <- mread("irm4",   modlib())
mod <- mread("emax",   modlib())
mod <- mread("effect", modlib())
mod <- mread("tmdd",   modlib())
mod <- mread("viral1", modlib())
mod <- mread("viral2", modlib())
mod <- mread("pred1",  modlib())
mod <- mread("pbpk",   modlib())
mod <- mread("1005",   modlib())  # embedded NONMEM result
mod <- mread("nm-like", modlib()) # model with nonmem-like syntax
mod <- mread("evtools", modlib())

as.list(mod)$code
}
}
