% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcode.R
\name{mcode}
\alias{mcode}
\alias{mcode_cache}
\title{Write, compile, and load model code}
\usage{
mcode(model, code, project = getOption("mrgsolve.project", tempdir()), ...)

mcode_cache(
  model,
  code,
  project = getOption("mrgsolve.project", tempdir()),
  ...
)
}
\arguments{
\item{model}{model name.}

\item{code}{character string specifying a \code{mrgsolve} model.}

\item{project}{project directory for the model.}

\item{...}{passed to \code{\link[=mread]{mread()}}; see that help topic for other arguments
that can be set.}
}
\description{
This is a convenience function that ultimately calls \code{\link[=mread]{mread()}}.
Model code is written to a file and read back in using \code{\link[=mread]{mread()}}.
}
\details{
Note that the arguments are in slightly different order than
\code{\link[=mread]{mread()}}.  The default \code{project} is \code{\link[=tempdir]{tempdir()}}.

See the \code{\link[=mread]{mread()}} help topic for discussion about caching
compilation results with \code{\link[=mcode_cache]{mcode_cache()}}.
}
\examples{
\dontrun{ 
code <- '
$CMT DEPOT CENT
$PKMODEL ncmt=1, depot=TRUE
$MAIN
double CL = 1;
double V = 20;
double KA = 1;
'

mod <- mcode("example", code, compile = FALSE)
}

}
\seealso{
\code{\link[=mread]{mread()}}, \code{\link[=mread_cache]{mread_cache()}}
}
