% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/events.R
\name{as.ev}
\alias{as.ev}
\alias{as.ev,data.frame-method}
\alias{as.ev,ev-method}
\title{Coerce an object to class ev}
\usage{
as.ev(x, ...)

\S4method{as.ev}{data.frame}(x, keep_id = TRUE, clean = FALSE, ...)

\S4method{as.ev}{ev}(x, ...)
}
\arguments{
\item{x}{an object to coerce.}

\item{...}{not used.}

\item{keep_id}{if \code{TRUE}, ID column is retained if it exists.}

\item{clean}{if \code{TRUE}, only dosing or ID information is retained in
the result.}
}
\value{
An object with class ev.
}
\description{
Use this function to convert a data frame to an event object.
}
\details{
If \code{CMT} (or \code{cmt}) is missing from the input, it will be set to 1
in the event object.

If \code{TIME} (or \code{time}) is missing from the input, it will be set to
0 in the event object.

If \code{EVID} (or \code{evid}) is missing from the input, it will be set to
1 in the event object.
}
\examples{
data <- data.frame(AMT = 100) 

as.ev(data)

as.ev(data, clean = TRUE)

}
