% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim.R
\name{sim_curve}
\alias{sim_curve}
\title{Power curve using Monte Carlo simulation}
\usage{
sim_curve(
  xmod,
  ymod,
  imod,
  s = 100,
  n = 100,
  cores = 1,
  file = NULL,
  errorhandling = "stop",
  snr_iter = 10000,
  cluster_export = c()
)
}
\arguments{
\item{xmod}{A MixtureModel object.}

\item{ymod}{One or a list of OutcomeModel object(s).}

\item{imod}{An InferenceModel object.}

\item{s}{An integer for the number of Monte Carlo simulations.}

\item{n}{An integer or a vector of sample sizes.}

\item{cores}{An integer for the number of processing cores. When cores > 1,
parallelism is automatically applied.}

\item{file}{A string, a file name with no extension to write samples to
periodically. By default write to an RDS file.}

\item{errorhandling}{A string "remove", "stop", or "pass". If an error occurs
in any iteration, remove that iteration (remove), return the error message
verbatim in the output (pass), or terminate the loop (stop). Default is
"remove". See R package 'foreach' for more details.}

\item{snr_iter}{An integer for number of Monte Carlo samples to estimate SNR.}

\item{cluster_export}{A vector of functions to pass to the
parallel-processing clusters.}
}
\value{
A SimCurve object with the following attributes:
  \item{s}{a number of simulations.}
  \item{snr}{a real number or array of real numbers for SNR of each OutcomeModel.}
  \item{n}{a number or vector of sample sizes.}
  \item{xmod}{the MixtureModel used.}
  \item{ymod}{the OutcomeModel used.}
  \item{imod}{the InferenceModel used.}
  \item{sims}{a list of simulation output matrices.}
}
\description{
This function can be used to create power curves by calling sim_power() on
combinations of many sample sizes and signal-to-noise ratio (SNR).
}
\examples{
data("nhanes1518")
chems <- c("URXCNP", "URXCOP", "URXECP", "URXHIBP", "URXMBP", "URXMC1",
"URXMCOH", "URXMEP","URXMHBP", "URXMHH", "URXMHNC", "URXMHP", "URXMIB",
"URXMNP", "URXMOH", "URXMZP")
chems_mod <- mpower::MixtureModel(nhanes1518[, chems], method = "resampling")
bmi_mod <- mpower::OutcomeModel(f = "0.2*URXCNP + 0.15*URXECP +
0.1*URXCOP*URXECP", family = "binomial")
logit_mod <- mpower::InferenceModel(model = "glm", family = "binomial")
logit_out <- mpower::sim_curve(xmod=chems_mod, ymod=bmi_mod, imod=logit_mod,
s=20, n=c(500, 1000), cores=2, snr_iter=1000)
logit_df <- summary(logit_out, crit="pval", thres=0.05, how="lesser")
plot_summary(logit_out, crit="pval", thres=0.05, how="lesser")
}
