% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mpae_package.R
\docType{data}
\name{hbat}
\alias{hbat}
\title{HBAT data}
\format{
A data frame with 200 rows and 24 columns:
\describe{
\item{empresa}{Customer ID.}
\item{tcliente}{Customer Type. Length of time a particular customer has been
buying from HBAT: \code{Menos de 1 año} = less than 1 year. \code{De 1 a 5 años} = between 1 and 5 years.
\code{Más de 5 años} = longer than 5 years.}
\item{tindustr }{Type of industry that purchases HBAT’s paper products:
\code{Revista} = magazine industry, \code{Periodico} = newsprint industry.}
\item{tamaño}{Employee size:
\code{Pequeña (<500)} = small firm, fewer than 500 employees,
\code{Grande (>=500)} = large firm, 500 or more employees.}
\item{region}{Customer location:
\code{America del norte} = USA/North America, \code{Otros} = outside North America.}
\item{distrib}{Distribution System. How paper products are sold to customers:
\code{Indirecta} = sold indirectly through a broker, \code{Directa} = sold directly.}
\item{calidadp}{Product Quality. Perceived level of quality of HBAT’s paper
products.}
\item{web}{E-Commerce Activities/Web Site. Overall image of HBAT’s Web site,
especially user-friendliness.}
\item{soporte}{Technical Support. Extent to which technical support is offered
to help solve product/service issues.}
\item{quejas}{Complaint Resolution. Extent to which any complaints are
resolved in a timely and complete manner.}
\item{publi}{Advertising. Perceptions of HBAT’s advertising campaigns in all
types of media.}
\item{producto}{Product Line. Depth and breadth of HBAT’s product line to meet
customer needs.}
\item{imgfvent}{Salesforce Image. Overall image of HBAT’s salesforce.}
\item{precio}{Competitive Pricing. Extent to which HBAT offers competitive
prices.}
\item{garantia}{Warranty and Claims. Extent to which HBAT stands behind its
product/service warranties and claims.}
\item{nprod}{New Products. Extent to which HBAT develops and sells new
products.}
\item{facturac}{Ordering and Billing. Perception that ordering and billing
is handled efficiently and correctly.}
\item{flexprec}{Price Flexibility. Perceived willingness of HBAT sales reps
to negotiate price on purchases of paper products.}
\item{velocida}{Delivery Speed. Amount of time it takes to deliver the paper
products once an order has been confirmed.}
\item{satisfac}{Customer satisfaction with past purchases from HBAT,
measured on a 10-point graphic rating scale.}
\item{precomen}{Likelihood of recommending HBAT to other firms as a supplier
of paper products, measured on a 10-point graphic rating scale.}
\item{pcompra}{Likelihood of purchasing paper products from HBAT in the
future, measured on a 10-point graphic rating scale.}
\item{fidelida}{Percentage of Purchases from HBAT. Percentage of the
responding firm’s paper needs purchased from HBAT, measured on a 100-point
percentage scale.}
\item{alianza}{Perception of Future Relationship with HBAT. Extent to which
the customer/respondent perceives his or her firm would engage in strategic
alliance/partnership with HBAT:
\code{No} = Would not consider. \code{Si} = Yes, would consider strategic alliance or partnership.}
}
}
\source{
Hair et al. (1998).
}
\usage{
hbat
}
\description{
A dataset containing observations of customers of the industrial
distribution company HBAT.
The variables can be classified into three groups:
the first 6 (categorical) are shopper characteristics (data warehouse
classification), variables 7 to 19 (numerical) measure shopper perceptions
of HBAT and the last 5 are possible target variables (responses),
the purchase outcomes.
}
\details{
For more details, consult the reference
Hair et al. (1998).
}
\examples{
str(hbat)
as.data.frame(attr(hbat, "variable.labels"))
summary(hbat)
}
\references{
Hair, J. F., Anderson, R. E., Tatham, R. L., y Black, W. (1998).
\emph{Multivariate Data Analysis}. Prentice Hall.
}
\keyword{datasets}
