% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count_motifs.R
\name{show_motif}
\alias{show_motif}
\title{Plots an example for a motif with given motif identifier string taken from
the given graph.}
\usage{
show_motif(motif, net = NULL, lvl_attr = c("sesType"), directed = NULL, ...)
}
\arguments{
\item{motif}{motif identifier string for the motif}

\item{net}{network object}

\item{lvl_attr}{character vector specifying the attribute name where level
information is stored in \code{net}.}

\item{directed}{whether the graph shall be treated as a directed graph. Per
default (\code{NULL}), this is determined automatically using the structure
of the provided network object}

\item{...}{additional arguments to be passed to plotting function (e.g.
\code{label = TRUE})}
}
\value{
plot
}
\description{
If no network is provided, a motif in a dummy network
(\code{motifr::dummy_net} or \code{motifr::large_directed_dummy_net}) will be
shown.
}
\examples{
\dontrun{
show_motif("1,2[I.C]", net = ml_net, directed = FALSE, label = TRUE)
}
}
\seealso{
\code{motifr::exemplify_motif}
}
