% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{mo_tri}
\alias{mo_tri}
\title{Moments of Order Statistics from the Symmetric Triangular Distribution}
\usage{
mo_tri(r, n, k = 1)
}
\arguments{
\item{r}{rank(s) of the desired order statistic(s) (e.g., \code{1} for the smallest order statistic).}

\item{n}{sample size from which the order statistic is derived.}

\item{k}{order of the moment to compute (default is \code{1}).}
}
\value{
The \eqn{k}th moment of the \eqn{r}th order statistic from a symmetric triangular distribution.
}
\description{
This function computes the moments of order statistics from the symmetric triangular distribution.
}
\details{
The function implements the following relationship from Nagaraja (2013)
for the symmetric triangular distribution:

\deqn{
\text{E}[X_{r:n}^k] = \frac{n!}{(r-1)!(n-r)!} \left\{
(\frac{1}{2})^{k/2} B\left(\frac{1}{2}; \frac{k}{2} + r, n - r + 1\right) +
\sum_{j=0}^k (-1)^j \binom{k}{j} (\frac{1}{2})^{j/2}
B\left(\frac{1}{2}; \frac{j}{2} + n - r + 1, r\right)
\right\}.
}

Here, \eqn{B(x; a, b)} is the incomplete Beta function.
}
\examples{
# Compute the 2nd moment of the 3rd order statistic for n=5
mo_tri(3, 5, 2)

}
\references{
Nagaraja, H. N. (2013). \emph{Moments of order statistics and L-moments for the symmetric
triangular distribution.} Statistics & Probability Letters, 83(10), 2357-2363.
}
