% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-DoseResponse.R
\name{PlotDoseResponse}
\alias{PlotDoseResponse}
\alias{plot.DoseResponse}
\alias{plot.BinaryDoseResponse}
\alias{plot.CountDoseResponse}
\alias{plot.ContinuousDoseResponse}
\title{Plot dose-response from \code{DoseResponse} objects}
\usage{
\method{plot}{DoseResponse}(
  x,
  xlab = "Dose",
  ylab = NULL,
  main = NULL,
  log.scale = FALSE,
  addlegend = TRUE,
  dodge.width = 0,
  ...
)

\method{plot}{BinaryDoseResponse}(
  x,
  xlab = "Concentration",
  ylab = NULL,
  main = NULL,
  log.scale = FALSE,
  addlegend = TRUE,
  dodge.width = 0,
  ...
)

\method{plot}{CountDoseResponse}(
  x,
  xlab = "Concentration",
  ylab = NULL,
  main = NULL,
  log.scale = FALSE,
  addlegend = TRUE,
  dodge.width = 0,
  ...
)

\method{plot}{ContinuousDoseResponse}(
  x,
  xlab = "Concentration",
  ylab = NULL,
  main = NULL,
  log.scale = FALSE,
  addlegend = TRUE,
  dodge.width = 0,
  ...
)
}
\arguments{
\item{x}{an object of class \code{BinaryData}, \code{CountData} or
\code{ContinuousData}}

\item{xlab}{a label for the \eqn{X}-axis, by default \code{Dose}}

\item{ylab}{a label for the \eqn{Y}-axis, by default \code{Response}}

\item{main}{main title for the plot}

\item{log.scale}{if \code{TRUE}, displays \eqn{X}-axis in log-scale}

\item{addlegend}{if \code{TRUE}, adds a default legend to the plot}

\item{dodge.width}{dodging width. Dodging preserves the vertical position
of an geom while adjusting the horizontal position.}

\item{\dots}{Further arguments to be passed to generic methods}
}
\value{
a plot of class \code{ggplot}
}
\description{
This is the generic \code{plot} S3 method for the \code{DoseResponse}
class. It plots the survival probability as a function of concentration at a given
target time.
\itemize{
\item For \code{BinaryData} object: The function plots the observed values of
the survival probability at a given time point
as a function of concentration. The 95\% binomial confidence interval is added
to each survival probability. It is calculated using function
\code{\link[stats]{binom.test}} from package \code{stats}.
Replicates are systematically pooled in this plot.
\item For \code{CountData} object: The function plots the observed values of
the Number of   at a given time point
as a function of concentration. The 95\% binomial confidence interval is added
to each survival probability. It is calculated using function
\code{poisson.test}.
Replicates are systematically pooled in this plot.
\item For \code{ContinuousData} object: the function plots observed values of the
response at a given time point as a function of concentration. The 95\% binomial
confidence interval is added
to each set of data at each concentration. It is calculated using function
\code{\link[stats]{t.test}} from package \code{stats}.
}
}
\keyword{plot}
