% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MOGIW.R
\name{MOGIW}
\alias{MOGIW}
\alias{dMOGIW}
\alias{pMOGIW}
\alias{qMOGIW}
\alias{rMOGIW}
\title{Marshall–Olkin Generalized Inverse Weibull Distribution (MOGIW)}
\usage{
dMOGIW(x, alpha, beta, lambda, theta, log = FALSE)

pMOGIW(q, alpha, beta, lambda, theta, lower.tail = TRUE, log.p = FALSE)

qMOGIW(p, alpha, beta, lambda, theta, lower.tail = TRUE, log.q = FALSE)

rMOGIW(n, alpha, beta, lambda, theta)
}
\arguments{
\item{x, q}{vector of quantile.}

\item{alpha}{scale parameter of the Generalized Inverse Weibull Distribution (GIW), where \eqn{\alpha > 0}.}

\item{beta}{shape parameter#1 of the Generalized Inverse Weibull Distribution (GIW), where \eqn{\beta > 0}.}

\item{lambda}{shape parameter#2 of the Generalized Inverse Weibull Distribution (GIW), where \eqn{\lambda > 0}.}

\item{theta}{Marshall–Olkin parameter, where \eqn{\theta > 0}.}

\item{log, log.p, log.q}{logical; (default = \code{FALSE}), if \code{TRUE}, then probabilities are given as \code{log(p)} or \code{log(q)}.}

\item{lower.tail}{logical; if \code{TRUE} (default), probabilities are \eqn{P[X \le x]}, otherwise, \eqn{P[X > x]}.}

\item{p}{vector of probabilities.}

\item{n}{number of observations. If \code{length(n) > 1}, the length is taken to be the number required.}
}
\value{
\code{dMOGIW} gives the density,
\code{pMOGIW} gives the distribution function,
\code{qMOGIW} gives the quantile function
and \code{rMOGIW} generates random samples.
}
\description{
Density, distribution function, quantile function, and random generation function
for the MOGIW distribution with four parameters (\code{alpha}, \code{beta}, \code{lambda}, and \code{beta}).
See details in references (Salem, 2019).
}
\examples{
x <- seq(0.5,4,by=0.1)
dMOGIW(x,1,3,2,3)
p<- pMOGIW(q=x,1,3,2,3)
q<- qMOGIW(p,1,3,2,3)
q
rMOGIW(10,1,3,2,3)

x <- seq(0.5,4,by=0.1)
dMOGIW(x,1,3,2,3)          #or dMOGIW(x,alpha=1,beta=3,lambda=2,theta=3)
dMOGIW(x,1,3,2,3,log=TRUE) #or dMOGIW(x,alpha=1,beta=3,lambda=2,theta=3,log=TRUE)

q <- seq(1,4,by=0.1)
pMOGIW(q,1,3,2,3)   #or  pMOGIW(q,1,3,2,3,lower.tail = TRUE)
pMOGIW(q,1,3,2,3,lower.tail = FALSE)

q <- seq(0.5,1.5,by=0.01)
p <- pMOGIW(q,1,3,2,3)
x <- qMOGIW(p,1,3,2,3)

x <- rMOGIW(10,1,3,2,3)
x

}
\references{
Salem, H. M. (2019). The Marshall–Olkin Generalized Inverse Weibull Distribution: Properties and Application.
Modern Applied Science, 13(2), 54. doi:10.5539/mas.v13n2p54
}
