% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotFunctions.R
\name{plotPvals}
\alias{plotPvals}
\title{Plot the ECDF of p-values from resampling}
\usage{
plotPvals(x, outcome = 1, predictor = 1, title = TRUE, alpha = 0.05)
}
\arguments{
\item{x}{Output from \code{\link{resample}}, given that \code{sampMethod =
"bootstrap"} or \code{sampMethod = "split"}.}

\item{outcome}{Character string or numeric value (in terms of columns in the
dataset) to indicate which outcome to plot the p-value distribution for.}

\item{predictor}{Character string or numeric value (in terms of columns in
the dataset) to indicate which predictor to plot the p-value distribution
for.}

\item{title}{If \code{TRUE}, then a default title will be given according to
the outcome and predictor that are specified. If \code{FALSE}, then no
title will be plotted. A custom title may also be supplied by the user.}

\item{alpha}{The false discovery rate. Defaults to .05}
}
\value{
Returns a plot based on the relationship between a particular outcome
and predictor.
}
\description{
Plots the empirical cumulative distribution function of the p-values related
to iterated resampling via bootstrapping or multi-sample splitting.
}
\details{
See Meinshausen, Meier, & Buhlmann (2009) for details.
}
\examples{
\donttest{
x <- resample(ggmDat, sampMethod = "bootstrap")
plot(x, what = 'pvals')
plot(x, 'pvals', outcome = 'V2', predictor = 'V1')
}
}
\references{
Meinshausen, N., Meier, L., & Buhlmann, P. (2009). P-values for
high-dimensional regression. Journal of the American Statistical
Association. 104, 1671-1681.
}
\seealso{
\code{\link{resample}}
}
