% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotFunctions.R
\name{condPlot}
\alias{condPlot}
\title{Conditional effects plot}
\usage{
condPlot(
  out,
  to,
  from,
  swap = FALSE,
  avg = FALSE,
  compare = NULL,
  hist = FALSE,
  xlab = NULL,
  mods = NULL,
  nsims = 500,
  xn = NULL,
  getCIs = FALSE,
  discrete = FALSE,
  ylab = NULL,
  main = NULL,
  midline = TRUE
)
}
\arguments{
\item{out}{Output from \code{\link{fitNetwork}} or \code{\link{resample}}.
Can also provide the \code{fixedNets} or \code{betweenNet} element of the
\code{\link{mlGVAR}} output.}

\item{to}{Outcome variable, specified with character string or numeric value.}

\item{from}{Predictor variable, specified with character string or numeric
value.}

\item{swap}{Logical. Serves to switch the arguments for \code{to} and
\code{from}.}

\item{avg}{Logical. If \code{TRUE} then the average relationship between the
two variables is displayed. Only works for GGMs.}

\item{compare}{Two values can be supplied to indicate levels of the moderator
to be compared.}

\item{hist}{Logical. Determines whether to show a histogram of the data
distribution at the bottom of the plot.}

\item{xlab}{Character string for labeling the x-axis.}

\item{mods}{This argument will be removed. Model output is automatically
detected based on \code{fit} argument.}

\item{nsims}{Number of iterations to simulate the posterior distribution.}

\item{xn}{Numeric value to indicate how many values of the moderator should
be evaluated.}

\item{getCIs}{Logical. Only applies when \code{avg = TRUE}. If \code{getCIs =
  TRUE}, then the confidence intervals for the average difference between the
maximum and minimum of the moderator will be returned.}

\item{discrete}{Logical. Determines whether to treat the moderator as a
discrete or continuous variable.}

\item{ylab}{Character string for labeling the y-axis.}

\item{main}{Character string for labeling the title of the plot.}

\item{midline}{Logical. Only applies when \code{discrete = TRUE}. Shows a
line at the average level of the outcome.}
}
\value{
A plot of the conditional effects of one variable on another given
different levels of the moderator.
}
\description{
Creates a plot of the relationships between two variables at different levels
of the moderator. Only works for relationships that include an interaction.
}
\examples{
\donttest{
fit <- fitNetwork(ggmDat, 'M')
condPlot(fit, to = 'V5', from = 'V4')
condPlot(fit, to = 2, from = 3, avg = TRUE)
}
}
\seealso{
\code{\link{fitNetwork}, \link{resample}}
}
