% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootNet.R
\name{bootNet}
\alias{bootNet}
\title{Bootstrapping network estimation for moderated networks}
\usage{
bootNet(
  data,
  m = NULL,
  nboots = 10,
  lags = NULL,
  caseDrop = FALSE,
  rule = "OR",
  ci = 0.95,
  caseMin = 0.05,
  caseMax = 0.75,
  caseN = 10,
  threshold = FALSE,
  fits = NULL,
  type = "g",
  saveMods = TRUE,
  verbose = TRUE,
  fitCoefs = FALSE,
  size = NULL,
  nCores = 1,
  cluster = "mclapply",
  block = FALSE,
  maxiter = 10,
  directedDiag = FALSE,
  beepno = NULL,
  dayno = NULL,
  ...
)
}
\arguments{
\item{data}{Dataframe or matrix.}

\item{m}{Numeric or character string. Indicates which variable should be
treated as a moderator (if any).}

\item{nboots}{Number of bootstrapped samples.}

\item{lags}{Numeric or logical, to indicate whether or not a temporal network
is being estimated. Maximum of 1 lag -- meaningful values are either 1 or
\code{TRUE}.}

\item{caseDrop}{Logical. Determines whether to do a caseDrop bootstrap
procedure or not.}

\item{rule}{Only applies to GGMs (including between-subjects networks) when a
threshold is supplied. The \code{"AND"} rule will only preserve edges when
both corresponding coefficients have p-values below the threshold, while
the \code{"OR"} rule will preserve an edge so long as one of the two
coefficients have a p-value below the supplied threshold.}

\item{ci}{Numeric, between 0 and 1. The level of the confidence intervals
estimated. Defaults at .95}

\item{caseMin}{Numeric. The minimum proportion of the sample that should be
taken when \code{caseDrop = TRUE}. Provide a value between 0 and 1. The
value indicates the smallest proportion of the total sample size to test in
the case-dropping procedure,}

\item{caseMax}{Numeric. The maximum proportion of the sample that should be
taken when \code{caseDrop = TRUE}. Provide a value between 0 and 1. The
value indicates the largest proportion of the total sample size to test in
the case-dropping procedure,}

\item{caseN}{Numeric. The number of samples to draw at each sample size
tested when \code{caseDrop = TRUE}.}

\item{threshold}{Logical or numeric. If \code{TRUE}, then a default value of
.05 will be set. Indicates whether a threshold should be placed on the
bootstrapped samples. A significant choice by the researcher. Only applies
when a variable selection procedure is applied, or whether a
\code{\link{resample}} object is used as input.}

\item{fits}{A list of all fitted models, if available. Not likely to be used.}

\item{type}{See \code{type} argument in \code{\link{fitNetwork}} function.
This is where a variable selection model can be provided. This will fit the
same selected model across all iterations of the bootstrapping procedure.}

\item{saveMods}{Logical. Determines whether or not to return all of the
fitted models -- that is, all the models fit to each bootstrapped sample.
Defaults to \code{TRUE}, but if \code{FALSE} then models will not be
returned which can save memory.}

\item{verbose}{Logical. Determines whether a progress bar should be shown, as
well as whether messages should be shown.}

\item{fitCoefs}{Logical, refers to the argument in the
\code{\link{fitNetwork}} function. Most likely this should always be
\code{FALSE}.}

\item{size}{Numeric. Size of sample to use for bootstrapping. Not
recommended.}

\item{nCores}{If a logical or numeric value is provided, then the
bootstrapping procedure will be parallelized across multiple CPUs. If
numeric, this will specify the number of cores to use for the procedure. If
\code{TRUE}, then the
\code{\link[parallel:detectCores]{parallel::detectCores}} function of the
\code{parallel} package will be run to maximize the number of cores
available. Defaults to 1, which does not run any parallelization functions.}

\item{cluster}{Character string to indicate which type of parallelization
function to use, if \code{nCores > 1}. Options are \code{"mclapply"} or
\code{"SOCK"}.}

\item{block}{Logical or numeric. If specified, then this indicates that
\code{lags != 0} or \code{lags != NULL}. If numeric, then this indicates
that block bootstrapping will be used, and the value specifies the block
size. If \code{TRUE} then an appropriate block size will be estimated
automatically.}

\item{maxiter}{The maximum number of iterations for the algorithm to go
through before stopping. In some circumstances, iterated versions of the
model based on subsamples of the data may not be possible to fit. In these
cases, \code{maxiter} specifies the number of attempts that are made with
different versions of the sample before stopping the algorithm.}

\item{directedDiag}{logical}

\item{beepno}{Character string or numeric value to indicate which variable
(if any) encodes the survey number within a single day. Must be used in
conjunction with \code{dayno} argument.}

\item{dayno}{Character string or numeric value to indicate which variable (if
any) encodes the survey number within a single day. Must be used in
conjunction with \code{beepno} argument.}

\item{...}{Additional arguments.}
}
\value{
A \code{bootNet} object
}
\description{
Follows closely to the methods of bootstrapping found in the \code{bootnet}
package. An essential goal behind this function is to expand the methods in
\code{bootnet} to encompass moderated networks.
}
\details{
Can be used to perform bootstrapped network estimation, as well as perform a
case-drop bootstrap. Details on these two methods can be found in the help
page for the \code{bootnet::bootnet} function.

The defining feature of \code{\link{bootNet}} that differentiates it from the
\code{\link{resample}} function when \code{sampMethod = "bootstrap"} is that
the \emph{same model is fit at every iteration} in \code{\link{bootNet}}. The only
time that models may differ across iterations is if a \code{threshold} is
specified. When \code{threshold = FALSE}, then the saturated model is fit to
each bootstrapped sample. Alternatively, bootstrapping can be performed with
respect to a specific constrained model. In this case, the constrained model
(variable selection model; output of \code{\link{varSelect}} or
\code{\link{resample}}) can be supplied to the \code{type} argument, and thus
this function provides a way to estimate the posterior distributions of the
nodes based on a constrained model.

In addition to expanding \code{bootnet} to handle moderated networks, there
are also some additional features such as the capacity to perform the block
bootstrap for temporal networks via the \code{block} argument. The block
bootstrap is \strong{highly} recommended for resampling temporal networks.

Another feature of this function is that it can be used on outputs from the
\code{\link{resample}} function. This can be used as a way to evaluate the
iterations of \code{\link{resample}} beyond just using it for variable
selection.
}
\section{Warning}{


Importantly, if output from the \code{\link{resample}} function is used as
input for the \code{\link{bootNet}} function, and the user wishes to use
the model selected by the \code{\link{resample}} function as the comparison
to the bootstrapped results, you must add the \code{fit0} argument to this
function. Use the fitted object in the \code{\link{resample}} output as the
input for the undocumented \code{fit0} argument for the
\code{\link{bootNet}} function.
}

\examples{
\donttest{
boot1 <- bootNet(ggmDat, 'M')
summary(boot1)

boot2 <- bootNet(gvarDat, 'M', lags = 1)

mod1 <- varSelect(gvarDat, 'M', lags = 1)
boot3 <- bootNet(gvarDat, 'M', lags = 1, type = mod1, caseDrop = TRUE)
summary(boot3)
}
}
\seealso{
\code{\link{summary.bootNet}, \link{fitNetwork}, \link{varSelect},
  \link{resample}, \link{plotBoot}, \link{plotNet}, \link{net},
  \link{netInts}}
}
