% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_simulated_data.R
\name{generate_simulated_data}
\alias{generate_simulated_data}
\title{Generate new data set by using previous correlation matrix}
\usage{
generate_simulated_data(
  data,
  df_sim,
  variables,
  bin_variables,
  categ_variables,
  count_variables,
  n_samples,
  generalized_mode,
  generalized_mode_lmbds,
  multi_sugg_prop,
  pertr_vec,
  var_infl,
  infl_cov_stable
)
}
\arguments{
\item{data}{a data frame with original variables.}

\item{df_sim}{a data frame with simulated values.}

\item{variables}{variables a character vector indicating which
columns of \code{data} should be used.}

\item{bin_variables}{a character vector listing the binary variables.}

\item{categ_variables}{a character vector listing the ordinal categorical
variables.}

\item{count_variables}{a character vector listing the count as a sub
sub category of categorical variables. Count variables should be part
of categorical variables vector. Count variables are treated differently
when using gldex to simulate them.}

\item{n_samples}{Number of rows of each simulated data set. Default is
the number of rows of \code{data}.}

\item{generalized_mode}{A logical value indicating if generalized lambda/poisson
distributions or set up thresholds will be used to generate the simulated values}

\item{generalized_mode_lmbds}{A matrix that contains lmbds values for each of the
variables of the data set to be used for either Generalized Lambda Distribution
Generalized Poisson Distribution or setting up thresholds}

\item{multi_sugg_prop}{A named vector that provides a  proportion of
value=1 for specific binary variables(=name of the vector) that will be
the close to the proportion of this value in the simulated data sets.}

\item{pertr_vec}{A named vector.Vector's names are the continuous variables
that the user want to perturb. Variance of simulated data set mimic original
data's variance.}

\item{var_infl}{A named vector.Vector's names are the continuous variables
that the user want to perturb and increase their variance}

\item{infl_cov_stable}{Logical value. If TRUE,perturbation is applied to
original data set and simulations values mimic the perturbed original data
set.Covariance matrix used for simulation = original data's correlations.
If FALSE, perturbation is applied to the simulated data sets.}
}
\value{
A data frame with simulated values
}
\description{
This function is used internally by \code{\link[modgo]{modgo}}. It conducts
the computation of the correlation matrix of the transformed variables, which
are assumed to follow a multivariate normal distribution.
}
\author{
Francisco M. Ojeda, George Koliopanos
}
\keyword{Normal}
\keyword{rank}
\keyword{transformation}
