% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpreters.R
\name{iht_interpreter}
\alias{iht_interpreter}
\title{Interpret Results of Informative Hypothesis Test}
\usage{
iht_interpreter(iht_res, alpha = 0.05)
}
\arguments{
\item{iht_res}{A 'conTest' object containing the results of an informative
hypothesis test.}

\item{alpha}{The significance level for interpreting the p-values. Default is
0.05.}
}
\value{
A character string providing a detailed interpretation of the
hypothesis test results.
}
\description{
This function provides a human-readable explanation of the results of an
informative hypothesis test. It interprets the p-values of both Type A and
Type B tests and provides an overall conclusion.
}
\examples{
model <- mmir_model(mpg ~ -1 + hp + wt, data = mtcars, engine = "lm",
                    standardize = TRUE)
iht_res <- restriktor::iht(model, constraints = 'hp < wt')
iht_interpreter(iht_res) |> cat()

}
\references{
Vanbrabant, L., & Rosseel, Y. (2020). An Introduction to Restriktor:
Evaluating informative hypotheses for linear models. In R. van de Schoot & M.
Miocevic (Eds.), Small Sample Size Solutions: A Guide for Applied Researchers
and Practitioners (1st ed., pp. 157 -172). Routledge.
}
