% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlts_pp_check.R
\name{mlts_pp_check}
\alias{mlts_pp_check}
\title{Posterior Predictive Checks for Multilevel Latent Time Series Models}
\usage{
mlts_pp_check(
  fit,
  fit_list = NULL,
  ts = NULL,
  y_reps = NULL,
  by_cluster = FALSE,
  by_group = FALSE,
  cluster_ids = NULL,
  draw_person_pars = FALSE,
  n_draws = 10,
  draws = NULL,
  add_y_obs = TRUE,
  model_lab = NULL,
  y_rep_col = NULL,
  y_obs_col = "#009E73",
  y_obs_lw = 1.1,
  y_rep_lw = 0.5,
  y_rep_alpha = 0.5
)
}
\arguments{
\item{fit}{A fitted model object of class \code{mlts.fit}. Only used if \code{fit_list} is \code{NULL}.}

\item{fit_list}{An optional list of fitted \code{mlts.fit} objects for model comparison. If provided, \code{fit} is ignored.}

\item{ts}{Optional vector of variable names to include in the plot.}

\item{y_reps}{Optional. A list of posterior predictive samples (as returned by \code{\link{mlts_posterior_sample}}) for a single model.
If \code{NULL}, samples are generated within the function.}

\item{by_cluster}{Logical. If \code{TRUE}, density plots are faceted by individual and time-series variable.
If \code{FALSE}, only time-series variables are used for faceting. Default is \code{FALSE}.}

\item{by_group}{Logical. If \code{TRUE}, density plots are faceted by grouping and time-series variable.
If \code{FALSE}, only time-series variables are used for faceting. Default is \code{FALSE}.}

\item{cluster_ids}{Optional vector of cluster IDs to include in the plot. If \code{NULL}, all IDs are shown.}

\item{draw_person_pars}{Logical. If \code{TRUE}, samples are generated using person-specific parameters (random effects).
If \code{FALSE}, only population-level parameters are used. Defaults to \code{FALSE}.}

\item{n_draws}{Integer. Number of posterior draws to use for generating replicated datasets. Defaults to 20.
Ignored if \code{draws} is specified.}

\item{draws}{Optional vector of indices specifying which posterior draws to use. If \code{NULL}, \code{n_draws} samples are drawn randomly.}

\item{add_y_obs}{Logical. Whether to include the observed data distribution in the plot. Defaults to \code{TRUE}.}

\item{model_lab}{Optional character vector with labels for each model in \code{fit_list}. If \code{NULL}, defaults to "Model 1", "Model 2", etc.}

\item{y_rep_col}{Optional vector of colors for the posterior predictive densities of each model. If \code{NULL}, a default color palette is used.}

\item{y_obs_col}{Color for the observed data distribution. Default is \code{"#009E73"}.}

\item{y_obs_lw}{Line width of the observed data density curve. Default is \code{1.1}.}

\item{y_rep_lw}{Line width of the observed data density curve. Default is \code{0.5}.}

\item{y_rep_alpha}{Alpha transparency for the predictive density curves. Default is \code{0.5}.}
}
\value{
A \code{ggplot} object showing density curves of observed and replicated data across time-series variables
(and optionally across individuals).
}
\description{
{Developemental} This function plots posterior predictive distributions of one or multiple fitted \code{mlts.fit} models.
Simulated data from posterior draws are compared to the observed data to visually assess model fit.
}
\details{
This function performs graphical posterior predictive checks by overlaying kernel density estimates of replicated
data from the posterior with the observed data. This can be used to visually assess how well a fitted model captures
key distributional aspects of the observed time series. If \code{fit_list} is specified, multiple models can be
compared side-by-side in the same plot.

If \code{draw_person_pars = TRUE}, simulated datasets incorporate subject-specific effects (random effects).
This requires that \code{monitor_person_pars = TRUE} was set during model fitting.
}
\examples{
\dontrun{
# Set up AR(1) model
ar1 <- mlts_model(q = 1, censor_left = -1)

# Simulate data under the AR(1) model
simData <- mlts_sim(model = ar1, N = 50, TP =100, default = TRUE)

# Fit the model
fit_AR <- mlts_fit(model = ar1, data = simData$data,
                   id = "ID", ts = "Y1", monitor_person_pars = TRUE)

# Run posterior predictive check
mlts_pp_check(fit = fit_AR,
              model_lab = "AR(1)",
              y_rep_col = "steelblue")

}

}
\seealso{
\code{\link{mlts_posterior_sample}} for generating replicated data samples.
}
