% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TuningInstanceBatchSingleCrit.R
\name{autoplot.TuningInstanceBatchSingleCrit}
\alias{autoplot.TuningInstanceBatchSingleCrit}
\title{Plots for Tuning Instances}
\usage{
\method{autoplot}{TuningInstanceBatchSingleCrit}(
  object,
  type = "marginal",
  cols_x = NULL,
  trafo = FALSE,
  learner = mlr3::lrn("regr.ranger"),
  grid_resolution = 100,
  theme = theme_minimal(),
  ...
)
}
\arguments{
\item{object}{(\link[mlr3tuning:TuningInstanceBatchSingleCrit]{mlr3tuning::TuningInstanceBatchSingleCrit}.}

\item{type}{(character(1)):\cr
Type of the plot. See description.}

\item{cols_x}{(\code{character()})\cr
Column names of hyperparameters.
By default, all untransformed hyperparameters are plotted.
Transformed hyperparameters are prefixed with \code{x_domain_}.}

\item{trafo}{(\code{logical(1)})\cr
If \code{FALSE} (default), the untransformed hyperparameters are plotted.
If \code{TRUE}, the transformed hyperparameters are plotted.}

\item{learner}{(\link[mlr3:Learner]{mlr3::Learner})\cr
Regression learner used to interpolate the data of the surface plot.}

\item{grid_resolution}{(\code{numeric()})\cr
Resolution of the surface plot.}

\item{theme}{(\code{\link[ggplot2:theme]{ggplot2::theme()}})\cr
The \code{\link[ggplot2:ggtheme]{ggplot2::theme_minimal()}} is applied by default to all plots.}

\item{...}{(ignored).}
}
\value{
\code{\link[ggplot2:ggplot]{ggplot2::ggplot()}}.
}
\description{
Visualizations for \link[mlr3tuning:TuningInstanceBatchSingleCrit]{mlr3tuning::TuningInstanceBatchSingleCrit}.
The argument \code{type} controls what kind of plot is drawn.
Possible choices are:
\itemize{
\item \code{"marginal"} (default): Scatter plots of x versus y.
The color of the points shows the batch number.
\item \code{"performance"}: Scatter plots of batch number versus y
\item \code{"parameter"}: Scatter plots of batch number versus input.
The color of the points shows the y values.
\item \code{"parallel"}: Parallel coordinates plot.
hyperparameters are rescaled by \code{(x - mean(x)) / sd(x)}.
\item \code{"points"}: Scatter plot of two x dimensions versus.
The color of the points shows the y values.
\item \code{"surface"}: Surface plot of two x dimensions versus y values.
The y values are interpolated with the supplied \link[mlr3:Learner]{mlr3::Learner}.
\item \code{"pairs"}: Plots all x and y values against each other.
\item \code{"incumbent"}: Plots the incumbent versus the number of configurations.
}
}
\examples{
if (requireNamespace("mlr3tuning") && requireNamespace("patchwork")) {
  library(mlr3tuning)

  learner = lrn("classif.rpart")
  learner$param_set$values$cp = to_tune(0.001, 0.1)
  learner$param_set$values$minsplit = to_tune(1, 10)

  instance = ti(
    task = tsk("iris"),
    learner = learner,
    resampling = rsmp("holdout"),
    measure = msr("classif.ce"),
    terminator = trm("evals", n_evals = 10))

  tuner = tnr("random_search")

  tuner$optimize(instance)

  # plot performance versus batch number
  autoplot(instance, type = "performance")

  # plot cp values versus performance
  autoplot(instance, type = "marginal", cols_x = "cp")

  # plot transformed parameter values versus batch number
  autoplot(instance, type = "parameter", trafo = TRUE)

  # plot parallel coordinates plot
  autoplot(instance, type = "parallel")

  # plot pairs
  autoplot(instance, type = "pairs")
}
}
