% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PipeOpInfo.R
\name{mlr_pipeops_info}
\alias{mlr_pipeops_info}
\alias{PipeOpInfo}
\title{Customizable Information Printer}
\format{
\code{\link[R6:R6Class]{R6Class}} object inheriting from \code{\link{PipeOp}}
}
\description{
\code{PipeOpInfo} prints its input to the console or a logger in a customizable way.
Users can define how specific object classes should be displayed using custom printer functions.
}
\section{Construction}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{PipeOpInfo$new(id = "info", collect_multiplicity = FALSE, log_target = "lgr::mlr3/mlr3pipelines::info")
}\if{html}{\out{</div>}}
\itemize{
\item \code{id} :: \code{character(1)}\cr
Identifier of resulting object, default "info"
\item \code{printer} :: \code{list} \cr
Optional mapping from object classes to printer functions. Custom functions override default printer-functions.
\item \code{collect_multiplicity} :: \code{logical(1)}\cr
If \code{TRUE}, the input is a \code{\link{Multiplicity}} collecting channel. \code{\link{Multiplicity}} input/output is accepted and the members are aggregated.
\item \code{log_target} :: \code{character(1)}\cr
Specifies how the input object is printed to the console. By default it is
directed to a logger, whose address can be customized using the form
\verb{<output>::<argument1>::<argument2>}. Otherwise it can be printed
as "message", "warning" or "cat". When set to "none", no customized
information about the object will be printed.
}
}

\section{Input and Output Channels}{

\code{PipeOpInfo} has one input channel called "input", it can take any type of input (\code{*}).
\code{PipeOpInfo} has one output channel called "output", it can take any type of output (\code{*}).
}

\section{State}{

The \verb{$state} is left empty (\code{list()}).
}

\section{Internals}{

\code{PipeOpInfo} forwards its input unchanged, but prints information about it
depending on the \code{printer} and \code{log_target} settings.
}

\section{Fields}{

Fields inherited from \code{PipeOp}, as well as:
\itemize{
\item \code{printer} :: \code{list}\cr
Mapping of object classes to printer functions. Includes printer-specifications for \code{Task}, \code{Prediction}, \code{NULL}. Otherwise object is printed as is.
\item \code{log_target} :: \code{character(1)} \cr
Specifies current output target.
}
}

\section{Methods}{

Only methods inherited from \code{\link{PipeOp}}.
}

\examples{
library("mlr3")

poinfo = po("info")
poinfo$train(list(tsk("mtcars")))
poinfo$predict(list(tsk("mtcars")))

# Specify customized console output for Task-objects
poinfo = po("info", log_target = "cat",
  printer = list(Task = function(x) list(head_data = head(x$data()), nrow = nrow(x$data())))
)

poinfo$train(list(tsk("iris")))
poinfo$predict(list(tsk("iris")))

}
\seealso{
https://mlr-org.com/pipeops.html

Other PipeOps: 
\code{\link{PipeOp}},
\code{\link{PipeOpEncodePL}},
\code{\link{PipeOpEnsemble}},
\code{\link{PipeOpImpute}},
\code{\link{PipeOpTargetTrafo}},
\code{\link{PipeOpTaskPreproc}},
\code{\link{PipeOpTaskPreprocSimple}},
\code{\link{mlr_pipeops}},
\code{\link{mlr_pipeops_adas}},
\code{\link{mlr_pipeops_blsmote}},
\code{\link{mlr_pipeops_boxcox}},
\code{\link{mlr_pipeops_branch}},
\code{\link{mlr_pipeops_chunk}},
\code{\link{mlr_pipeops_classbalancing}},
\code{\link{mlr_pipeops_classifavg}},
\code{\link{mlr_pipeops_classweights}},
\code{\link{mlr_pipeops_classweightsex}},
\code{\link{mlr_pipeops_colapply}},
\code{\link{mlr_pipeops_collapsefactors}},
\code{\link{mlr_pipeops_colroles}},
\code{\link{mlr_pipeops_copy}},
\code{\link{mlr_pipeops_datefeatures}},
\code{\link{mlr_pipeops_decode}},
\code{\link{mlr_pipeops_encode}},
\code{\link{mlr_pipeops_encodeimpact}},
\code{\link{mlr_pipeops_encodelmer}},
\code{\link{mlr_pipeops_encodeplquantiles}},
\code{\link{mlr_pipeops_encodepltree}},
\code{\link{mlr_pipeops_featureunion}},
\code{\link{mlr_pipeops_filter}},
\code{\link{mlr_pipeops_fixfactors}},
\code{\link{mlr_pipeops_histbin}},
\code{\link{mlr_pipeops_ica}},
\code{\link{mlr_pipeops_imputeconstant}},
\code{\link{mlr_pipeops_imputehist}},
\code{\link{mlr_pipeops_imputelearner}},
\code{\link{mlr_pipeops_imputemean}},
\code{\link{mlr_pipeops_imputemedian}},
\code{\link{mlr_pipeops_imputemode}},
\code{\link{mlr_pipeops_imputeoor}},
\code{\link{mlr_pipeops_imputesample}},
\code{\link{mlr_pipeops_isomap}},
\code{\link{mlr_pipeops_kernelpca}},
\code{\link{mlr_pipeops_learner}},
\code{\link{mlr_pipeops_learner_pi_cvplus}},
\code{\link{mlr_pipeops_learner_quantiles}},
\code{\link{mlr_pipeops_missind}},
\code{\link{mlr_pipeops_modelmatrix}},
\code{\link{mlr_pipeops_multiplicityexply}},
\code{\link{mlr_pipeops_multiplicityimply}},
\code{\link{mlr_pipeops_mutate}},
\code{\link{mlr_pipeops_nearmiss}},
\code{\link{mlr_pipeops_nmf}},
\code{\link{mlr_pipeops_nop}},
\code{\link{mlr_pipeops_ovrsplit}},
\code{\link{mlr_pipeops_ovrunite}},
\code{\link{mlr_pipeops_pca}},
\code{\link{mlr_pipeops_proxy}},
\code{\link{mlr_pipeops_quantilebin}},
\code{\link{mlr_pipeops_randomprojection}},
\code{\link{mlr_pipeops_randomresponse}},
\code{\link{mlr_pipeops_regravg}},
\code{\link{mlr_pipeops_removeconstants}},
\code{\link{mlr_pipeops_renamecolumns}},
\code{\link{mlr_pipeops_replicate}},
\code{\link{mlr_pipeops_rowapply}},
\code{\link{mlr_pipeops_scale}},
\code{\link{mlr_pipeops_scalemaxabs}},
\code{\link{mlr_pipeops_scalerange}},
\code{\link{mlr_pipeops_select}},
\code{\link{mlr_pipeops_smote}},
\code{\link{mlr_pipeops_smotenc}},
\code{\link{mlr_pipeops_spatialsign}},
\code{\link{mlr_pipeops_splines}},
\code{\link{mlr_pipeops_subsample}},
\code{\link{mlr_pipeops_targetinvert}},
\code{\link{mlr_pipeops_targetmutate}},
\code{\link{mlr_pipeops_targettrafoscalerange}},
\code{\link{mlr_pipeops_textvectorizer}},
\code{\link{mlr_pipeops_threshold}},
\code{\link{mlr_pipeops_tomek}},
\code{\link{mlr_pipeops_tunethreshold}},
\code{\link{mlr_pipeops_unbranch}},
\code{\link{mlr_pipeops_updatetarget}},
\code{\link{mlr_pipeops_vtreat}},
\code{\link{mlr_pipeops_yeojohnson}}
}
\concept{PipeOps}
