% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formulate.R
\name{formulate}
\alias{formulate}
\title{Create Formulas}
\usage{
formulate(lhs = character(), rhs = character(), env = NULL, quote = "right")
}
\arguments{
\item{lhs}{(\code{character()})\cr
Left-hand side of formula. Multiple elements will be collapsed with \code{" + "}.}

\item{rhs}{(\code{character()})\cr
Right-hand side of formula. Multiple elements will be collapsed with \code{" + "}.}

\item{env}{(\code{environment()})\cr
Environment for the new formula. Defaults to \code{NULL}.}

\item{quote}{(\code{character(1)})\cr
Which side of the formula to quote?
Subset of \verb{("left", "right")}, defaulting to \code{"right"}.}
}
\value{
\code{\link[stats:formula]{stats::formula()}}.
}
\description{
Given the left-hand side and right-hand side as character vectors, generates a new
\code{\link[stats:formula]{stats::formula()}}.
}
\examples{
formulate("Species", c("Sepal.Length", "Sepal.Width"))
formulate(rhs = c("Sepal.Length", "Sepal.Width"))
}
