% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MKS_method.r
\name{MKS}
\alias{MKS}
\title{Mixable Kolmogorov Smirnov}
\usage{
MKS(p.score, n.score, test)
}
\arguments{
\item{p.score}{a numeric \code{vector} of positive scores estimated either from a
validation set or from a cross-validation method.}

\item{n.score}{a numeric \code{vector} of negative scores estimated either from a
validation set or from a cross-validation method.}

\item{test}{a numeric \code{vector} containing the score estimated for the positive class from
each test set instance.}
}
\value{
A numeric vector containing the class distribution estimated from the test set.
}
\description{
It quantifies events based on testing scores, applying the Mixable Kolmogorov
Smirnov (MKS) method proposed by Maletzke et al. (2019).
}
\examples{
library(randomForest)
library(caret)
cv <- createFolds(aeAegypti$class, 3)
tr <- aeAegypti[cv$Fold1,]
validation <- aeAegypti[cv$Fold2,]
ts <- aeAegypti[cv$Fold3,]

# -- Getting a sample from ts with 80 positive and 20 negative instances --
ts_sample <- rbind(ts[sample(which(ts$class==1),80),],
                   ts[sample(which(ts$class==2),20),])
scorer <- randomForest(class~., data=tr, ntree=500)
scores <- cbind(predict(scorer, validation, type = c("prob")), validation$class)
test.scores <- predict(scorer, ts_sample, type = c("prob"))
MKS(p.score = scores[scores[,3]==1,1], n.score = scores[scores[,3]==2,1],
test = test.scores)
}
\references{
Maletzke, A., Reis, D., Cherman, E., & Batista, G. (2019). DyS:
a Framework for Mixture Models in Quantification. in Proceedings of the The
Thirty-Third AAAI Conference on Artificial Intelligence, ser. AAAI’19, 2019.<doi.org/10.1609/aaai.v33i01.33014552>
}
