% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wb.r
\name{withinBetween}
\alias{withinBetween}
\title{Within between variance estimation}
\usage{
withinBetween(imps, analysisFun, pd = NULL, dfComplete = NULL, ...)
}
\arguments{
\item{imps}{A list of imputed datasets produced by one of the imputation functions
in \code{mlmi} or another package.}

\item{analysisFun}{A function to analyse the imputed datasets that when applied to
a dataset returns a list containing a vector \code{est} and covariance matrix \code{var}.}

\item{pd}{If \code{imps} was not generated by one of the imputation functions in
\code{mlmi}, this argument must be specified to indicate whether the imputations
were generated using posterior draws (TRUE) or not (FALSE).}

\item{dfComplete}{The complete data degrees of freedom. If \code{analysisFun} returns a vector
of parameter estimates, \code{dfComplete} should be a vector of the same length. If not
specified, it is assumed that the complete data degrees of freedom is effectively infinite (1e+05).}

\item{...}{Other parameters that are to be passed through to \code{analysisFun}.}
}
\value{
A list containing the overall parameter estimates, its corresponding covariance matrix, and
degrees of freedom for each parameter.
}
\description{
This function implements the within-between variance estimation approach. If the imputations
were generated using posterior draws, it implements the approach proposed by Barnard & Rubin (1999).
If posterior draws were not used, it implements the WB approach described by von Hippel and
Bartlett (2021).
}
\examples{
#simulate a partially observed dataset
set.seed(1234)
n <- 100
x <- rnorm(n)
y <- x+rnorm(n)
y[1:50] <- NA
temp <- data.frame(x,y)

#impute using normImp
imps <- normImp(temp, M=100, pd=TRUE, rseed=4423)

#define a function which analyses a dataset using our desired
#analysis model, returning the estimated parameters and their
#corresponding variance covariance matrix
analysisFun <- function(inputData) {
  mod <- lm(y~x, data=inputData)
  list(est=coef(mod), var=vcov(mod))
}
withinBetween(imps,analysisFun, dfComplete=c(n-2,n-2))
}
\references{
Barnard J, Rubin DB. Miscellanea. Small-sample degrees of freedom with multiple imputation.
Biometrika 1999; 86(4): 948-955. \doi{10.1093/biomet/86.4.948}

von Hippel P.T. and Bartlett J.W. Maximum likelihood multiple imputation: faster,
more efficient imputation without posterior draws. Statistical Science 2021; 36(3) 400-420 \doi{10.1214/20-STS793}.
}
