% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctx_node_covlmc.R
\name{metrics.ctx_node_covlmc}
\alias{metrics.ctx_node_covlmc}
\title{Predictive quality metrics for a node of a COVLMC context tree}
\usage{
\method{metrics}{ctx_node_covlmc}(model, ...)
}
\arguments{
\item{model}{A \code{ctx_node_covlmc} object as returned by \code{\link[=find_sequence]{find_sequence()}} or
\code{\link[=contexts.covlmc]{contexts.covlmc()}}}

\item{...}{Additional parameters for predictive metrics computation.}
}
\value{
an object of class \code{metrics.covlmc} with the following components:
\itemize{
\item \code{accuracy}: the accuracy of the predictions
\item \code{conf_mat}: the confusion matrix of the predictions, with predicted values
in rows and true values in columns
\item \code{auc}: the AUC of the predictive model
}
}
\description{
This function computes and returns predictive quality metrics for a node
(\code{ctx_node_covlmc}) extracted from a covlmc
}
\details{
Compared to \code{\link[=metrics.covlmc]{metrics.covlmc()}}, this function focuses on a single context and
assesses the quality of its predictions, disregarding observations that have
other contexts. Apart from this limited scope, the function operates as
\code{\link[=metrics.covlmc]{metrics.covlmc()}}.
}
\examples{
pc <- powerconsumption[powerconsumption$week == 5, ]
breaks <- c(
  0,
  median(powerconsumption$active_power, na.rm = TRUE),
  max(powerconsumption$active_power, na.rm = TRUE)
)
labels <- c(0, 1)
dts <- cut(pc$active_power, breaks = breaks, labels = labels)
dts_cov <- data.frame(day_night = (pc$hour >= 7 & pc$hour <= 17))
m_cov <- covlmc(dts, dts_cov, min_size = 5)
m_ctxs <- contexts(m_cov)
## get the predictive metrics for each context
lapply(m_ctxs, metrics)
}
\references{
David J. Hand and Robert J. Till (2001). "A Simple Generalisation
of the Area Under the ROC Curve for Multiple Class Classification Problems."
\emph{Machine Learning} 45(2), p. 171--186. DOI: \doi{10.1023/A:1010920819831}.
}
\seealso{
\code{\link[=metrics.vlmc]{metrics.vlmc()}}, \code{\link[=metrics.ctx_node]{metrics.ctx_node()}}, \code{\link[=contexts.vlmc]{contexts.vlmc()}}, \code{\link[=predict.vlmc]{predict.vlmc()}}.
}
