% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vlmc_as_cpp.R
\name{as_vlmc.ctx_tree_cpp}
\alias{as_vlmc.ctx_tree_cpp}
\title{Convert an object to a Variable Length Markov Chain (VLMC)}
\usage{
\method{as_vlmc}{ctx_tree_cpp}(x, alpha, cutoff, ...)
}
\arguments{
\item{x}{an object to convert into a vlmc.}

\item{alpha}{cut off parameter applied during the conversion, quantile scale
(if specified)}

\item{cutoff}{cut off parameter applied during the conversion, native scale
(if specified)}

\item{...}{additional arguments for conversion functions.}
}
\value{
a vlmc
}
\description{
This generic function converts an object into a vlmc.
}
\details{
This function converts a context tree into a VLMC. If \code{alpha} or
\code{cutoff} is specified, it is used to reduce the complexity of the tree as in
a direct call to \code{\link[=vlmc]{vlmc()}} (\code{\link[=prune]{prune()}}).
}
\examples{
## conversion from a context tree
dts <- c(0, 1, 1, 1, 0, 0, 1, 0, 1, 0)
dts_ctree <- ctx_tree(dts, min_size = 1, max_depth = 3, backend = "C++")
draw(dts_ctree)
dts_vlmc <- as_vlmc(dts_ctree)
class(dts_vlmc)
draw(dts_vlmc)

}
\seealso{
\code{\link[=ctx_tree]{ctx_tree()}}

\code{\link[=tune_vlmc]{tune_vlmc()}}
}
