% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power-curve-parallel.R
\name{mp_power_curve_parallel}
\alias{mp_power_curve_parallel}
\title{Parallel power curve evaluation}
\usage{
mp_power_curve_parallel(
  scenario,
  vary,
  workers = 2L,
  nsim = 100,
  alpha = 0.05,
  seed = NULL,
  failure_policy = c("count_as_nondetect", "exclude"),
  conf_level = 0.95,
  progress = FALSE,
  ...
)
}
\arguments{
\item{scenario}{An \code{mp_scenario}.}

\item{vary}{Named list with exactly one parameter (e.g. \code{clusters.subject}).}

\item{workers}{Number of parallel workers (default 2).}

\item{nsim}{Number of simulations per grid point (default 100).}

\item{alpha}{Significance level (default 0.05).}

\item{seed}{Optional base seed; each cell gets \code{seed + cell_index - 1L}.}

\item{failure_policy}{How to treat failed fits: \code{"count_as_nondetect"} or \code{"exclude"}.}

\item{conf_level}{Confidence level for power intervals (default 0.95).}

\item{progress}{If \code{TRUE}, run serially with a progress bar; if \code{FALSE}, run in parallel.}

\item{...}{Unused; reserved for future arguments.}
}
\value{
An object of class \code{mp_power_curve} (same structure as \code{\link[=mp_power_curve]{mp_power_curve()}}).
}
\description{
Evaluates power over a one-parameter grid by running \code{\link[=mp_power]{mp_power()}} for each
grid cell in parallel. Uses explicit per-cell seeds (seed + cell_index - 1L)
so results are deterministic and match serial \code{\link[=mp_power_curve]{mp_power_curve()}} for the same
seed. Does not modify \code{\link[=mp_power]{mp_power()}}; parallelization is at the scenario-grid
level only.
}
\note{
Parallel execution requires the \pkg{parallel} package (base R) and that
\pkg{mixpower} is installed (e.g. \code{install.packages()} or
\code{devtools::install()}) so that workers can load it.
}
