% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reproducibility.R
\name{mp_manifest}
\alias{mp_manifest}
\title{Reproducibility manifest for power analyses}
\usage{
mp_manifest(scenario, seed = NULL, session = TRUE)
}
\arguments{
\item{scenario}{An \code{mp_scenario} object (used for digest).}

\item{seed}{The seed value used (or \code{NULL}). Stored as-is; strategy is
inferred as \code{"fixed"} if non-null else \code{"none"}.}

\item{session}{Include full \code{sessionInfo()} (default \code{TRUE}). If \code{FALSE},
only R version and mixpower version are stored.}
}
\value{
A list with components: \code{scenario_digest}, \code{seed}, \code{seed_strategy},
\code{timestamp}, \code{r_version}, \code{mixpower_version}, \code{session_info} (if requested),
\code{git_sha} (if in a git repo). Use \code{\link[=as.data.frame]{as.data.frame()}} on the list for a
single-row table (list components become columns where possible).
}
\description{
Captures scenario fingerprint, seed strategy, session info, timestamp, and
optional git SHA so results can be reproduced or audited. Output is a plain
list (and one-row data frame via \code{\link[=as.data.frame]{as.data.frame()}}) suitable for saving
alongside results.
}
