% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dispatcher.R
\name{dispatcher}
\alias{dispatcher}
\title{Dispatcher}
\usage{
dispatcher(host, url = NULL, n = 0L)
}
\arguments{
\item{host}{(character) URL to dial into, typically an IPC address.}

\item{url}{(character) URL to listen at for daemon connections, e.g.
'tcp://hostname:5555'. Use 'tls+tcp://' for secure TLS.}

\item{n}{(integer) number of local daemons launched by host.}
}
\value{
Invisibly, an integer exit code: 0L for normal termination.
}
\description{
Dispatches tasks from a host to daemons for processing, using FIFO
scheduling, queuing tasks as required. Daemon / dispatcher settings are
controlled by \code{\link[=daemons]{daemons()}} and this function should not need to be called
directly.
}
\details{
Dispatcher acts as a gateway between the host and daemons, dispatching tasks
on a FIFO basis. Tasks are queued until a daemon is available for immediate
execution.
}
