% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/propdiff_ac.R
\name{propdiff_ac}
\alias{propdiff_ac}
\title{Calculates the difference between proportions and standard error
according to method Agresti-Caffo}
\usage{
propdiff_ac(y, x, formula, data)
}
\arguments{
\item{y}{0-1 binary response variable.}

\item{x}{0-1 binary independent variable.}

\item{formula}{A formula object to specify the model as normally used by glm.}

\item{data}{An objects of class \code{milist}, created by
\code{df2milist}, \code{list2milist} or \code{mids2milist}.}
}
\value{
The difference between proportions, the standard error
according to Agresti-Caffo and complete data degrees of freedom
(dfcom) as n-1.
}
\description{
\code{propdiff_ac} Calculates the difference between proportions
and standard error according to method Agresti-Caffo.
}
\details{
As output the differences between proportions according to
Agresti-Caffo and Wald are provided. The Agresti-Caffo difference is
used in the function \code{pool_propdiff_ac} to derive the Agresti-Caffo
confidence intervals. For the pooled difference between proportions
the difference between proportions according to Wald are used.
}
\examples{

imp_dat <- df2milist(lbpmilr, impvar="Impnr")
ra <- with(imp_dat, expr=propdiff_ac(Chronic ~ Radiation))

# same as
ra <- with(imp_dat, expr=propdiff_ac(y=Chronic, x=Radiation))

}
\references{
Agresti, A. and Caffo, B. Simple and Effective Confidence
Intervals for Proportions and Differences of Proportions Result from
Adding Two Successes and Two Failures. The American Statistician.
2000;54:280-288.

Fagerland MW, Lydersen S, Laake P. Recommended confidence
intervals for two independent binomial proportions. Stat Methods Med Res.
2015 Apr;24(2):224-54.
}
\seealso{
\code{\link{with.milist}}, \code{\link{pool_propdiff_ac}}
}
\author{
Martijn Heymans, 2021
}
