% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pool_cor.R
\name{pool_cor}
\alias{pool_cor}
\title{Calculates the pooled correlation coefficient and Confidence intervals}
\usage{
pool_cor(
  data,
  conf.level = 0.95,
  dfcom = NULL,
  statistic = TRUE,
  df_small = TRUE,
  approxim = "tdistr"
)
}
\arguments{
\item{data}{An object of class 'mistats' ('Multiply Imputed
Statistical Analysis'.) or a m x 2 matrix with C-index
values and standard errors in the first and second column.
For the latter option dfcom has to be provided.}

\item{conf.level}{conf.level Confidence level of the confidence intervals.}

\item{dfcom}{Number of completed-data analysis degrees of freedom.
Default number is taken from function \code{cindex}}

\item{statistic}{if TRUE (default) the test statistic and p-value are
provided, if FALSE these are not shown. See details.}

\item{df_small}{if TRUE (default) the (Barnard & Rubin) small sample
correction for the degrees of freedom is applied, if FALSE the old
number of degrees of freedom is calculated.}

\item{approxim}{if "tdistr" a t-distribution is used (default), if "zdistr"
a z-distribution is used to derive a p-value for the test statistic.}
}
\value{
An object of class \code{mipool} from which the following objects
can be extracted:
\itemize{
\item  \code{cor} correlation coefficient
\item  \code{SE} standard error
\item  \code{t} t-value (for confidence interval)
\item  \code{low_r} lower limit of confidence interval
\item  \code{high_r} upper limit of confidence interval
\item  \code{statistic} test statistic
\item  \code{pval} p-value
}
}
\description{
\code{pool_cor} Calculates the pooled correlation coefficient and
Confidence intervals.
}
\details{
Rubin's Rules are used for pooling. The correlation coefficient is
first transformed using Fisher z transformation (function \code{cor2fz}) before
pooling and finally back transformed (function \code{fz2cor}). The test
statistic and p-values are obtained using the Fisher z transformation.
}
\examples{

 imp_dat <- df2milist(lbpmilr, impvar="Impnr")
 res_stats <- with(data=imp_dat,
  expr = cor_est(y=BMI, x=Age))
 res <- pool_cor(res_stats)
 res

}
\seealso{
\code{\link{with.milist}}, \code{\link{cor_est}}
}
\author{
Martijn Heymans, 2022
}
