% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_ic50_from_file.R
\name{predict_ic50_from_file}
\alias{predict_ic50_from_file}
\title{Predict the half maximal inhibitory concentration (aka IC50) (in nM)
for one or more peptides as saved in a file.
Each peptide must be 15 amino acids at
most (use \link{predict_ic50s} to predict the IC50s for longer peptides)}
\usage{
predict_ic50_from_file(
  mhcnuggets_options,
  peptides_path,
  mhcnuggets_output_filename = mhcnuggetsr::create_temp_peptides_path(fileext = ".csv")
)
}
\arguments{
\item{mhcnuggets_options}{options to run MHCnuggets with,
as can be created by \link{create_mhcnuggets_options}.}

\item{peptides_path}{the path to the peptides}

\item{mhcnuggets_output_filename}{path to a temporary file to write
the MHCnuggets results to. This file will be deleted at the end of
the function if it passes successfully.}
}
\description{
Predict the half maximal inhibitory concentration (aka IC50) (in nM)
for one or more peptides as saved in a file.
Each peptide must be 15 amino acids at
most (use \link{predict_ic50s} to predict the IC50s for longer peptides)
}
\examples{
if (is_mhcnuggets_installed()) {

  peptides_path <- get_example_filename("test_peptides.peps")
  mhc_1_haplotype <- "HLA-A02:01"
  mhcnuggets_options <- create_mhcnuggets_options(
    mhc = mhc_1_haplotype
  )

  predict_ic50_from_file(
    peptides_path = peptides_path,
    mhcnuggets_options = mhcnuggets_options
  )
}
}
\author{
Richèl J.C. Bilderbeek
}
