% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crosswalks.R
\name{read_symbol_map}
\alias{read_symbol_map}
\title{Read marker symbol mappings}
\usage{
read_symbol_map(report_file = NULL, n_max = Inf)
}
\arguments{
\item{report_file}{The path to a MRK_List1.rpt file. Leave this as \code{NULL}
and the function will automatically download the report from
\url{https://www.informatics.jax.org/downloads/reports/MRK_List1.rpt}.}

\item{n_max}{Maximum number of lines to read.}
}
\value{
A \link[data.table:data.table]{data.table} where each row is a mapping,
from \code{marker_symbol} to \code{marker_symbol_now}:
\itemize{
\item \code{marker_symbol} (set as key): marker symbol is a unique abbreviation of the marker name.
\item \code{marker_symbol_now}: genetic marker symbol replacement. If the record pertains a  \code{marker_symbol} that was withdrawn, then \code{marker_symbol_now} indicates the most recent in-use marker symbol that replaced it.
}
}
\description{
\code{\link[=read_symbol_map]{read_symbol_map()}} reads MRK_List1.rpt data and returns an efficient
data table to be used for marker symbol remapping.

This function is memoised.
}
\keyword{internal}
