% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marker_types.R
\docType{data}
\name{marker_type_definitions}
\alias{marker_type_definitions}
\title{Genetic Marker Type Definitions}
\format{
A \link[tibble:tibble-package]{tibble} with
10 rows and 2
variables:

\describe{
\item{\code{marker_type}}{Character. The type of genetic marker.}
\item{\code{definition}}{Character. The definition of the marker type.}
}
}
\source{
The cross-references in the entry definition for marker at MGI glossary:
\url{https://www.informatics.jax.org/glossary/marker/}.
}
\usage{
marker_type_definitions
}
\description{
A dataset of marker types definitions.

Use instead \code{\link[=marker_types]{marker_types()}} for the marker type names as a single character
vector.
}
\examples{
print(marker_type_definitions, n = Inf)

}
\keyword{datasets}
