% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_model.R
\name{fit_model}
\alias{fit_model}
\title{Function that fits models supported by \code{mfp2}}
\usage{
fit_model(
  x,
  y,
  family = "gaussian",
  weights = NULL,
  offset = NULL,
  method = NULL,
  strata = NULL,
  control = NULL,
  rownames = NULL,
  nocenter = NULL,
  fast = TRUE
)
}
\arguments{
\item{x}{a matrix of predictors (excluding intercept) with column names.
If column names are not provided they are set according to
\code{colnames(x, do.NULL = FALSE)}.}

\item{y}{a vector for the outcome variable for glms, and a \code{Surv} object
for Cox models.}

\item{family}{a character strong specifying glm family to be used, or "cox"
for Cox models. The default family is set to 'Gaussian'.}

\item{method}{a character string specifying the method for tie handling.
See \code{\link[survival:coxph]{survival::coxph()}}.}

\item{strata, control, weights, offset, rownames, nocenter}{parameters for Cox
or glm. See \code{\link[survival:coxph]{survival::coxph()}} or \code{\link[stats:glm]{stats::glm()}} for details.}

\item{fast}{passed to \code{\link[=fit_glm]{fit_glm()}} and \code{\link[=fit_cox]{fit_cox()}}.

@return
A list with the following components:
\itemize{
\item \code{logl}: the log likelihood of the fitted model.
\item \code{coefficients}: regression coefficients.
\item \code{df}: number of parameters (degrees of freedom).
\item \code{sse}: residual sum of squares.
\item \code{fit}: the object returned by the fitting procedure.
}}
}
\description{
Fits generalized linear models and Cox proportional hazard models.
}
\details{
Computations rely on \code{\link[=fit_glm]{fit_glm()}} and \code{\link[=fit_cox]{fit_cox()}}.
}
