% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.mfp2.R
\name{calculate_standard_error}
\alias{calculate_standard_error}
\title{Helper function to compute standard error of a partial predictor}
\usage{
calculate_standard_error(model, X, xref = NULL)
}
\arguments{
\item{model}{fitted \code{mfp2} object.}

\item{X}{transformed input matrix with variables of interest for partial predictor.}

\item{xref}{transformed reference value for variable of interest. Default is
\code{NULL}, in which case this function computes standard errors without reference
values.}
}
\value{
Standard error.
}
\description{
To be used in \code{\link[=predict.mfp2]{predict.mfp2()}}.
}
\details{
See pages 91-92 and following in the book by Royston and Sauerbrei 2008
for the formulas and mathematical details.
}
\references{
Royston, P. and Sauerbrei, W., 2008. \emph{Multivariable Model - Building:
A Pragmatic Approach to Regression Anaylsis based on Fractional Polynomials
for Modelling Continuous Variables. John Wiley & Sons.}\cr
}
