% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_prevalence.R
\name{prevalence}
\alias{prevalence}
\alias{preval}
\alias{preval_t}
\title{Prevalence}
\usage{
preval(
  data = NULL,
  obs,
  pred,
  atom = FALSE,
  pos_level = 2,
  tidy = FALSE,
  na.rm = TRUE
)

preval_t(
  data = NULL,
  obs,
  pred,
  atom = FALSE,
  pos_level = 2,
  tidy = FALSE,
  na.rm = TRUE
)
}
\arguments{
\item{data}{(Optional) argument to call an existing data frame containing the data.}

\item{obs}{Vector with observed values (character | factor).}

\item{pred}{Vector with predicted values (character | factor).}

\item{atom}{Logical operator (TRUE/FALSE) to decide if the estimate is made for
each class (atom = TRUE) or at a global level (atom = FALSE); Default : FALSE.}

\item{pos_level}{Integer, for binary cases, indicating the order (1|2) of the level
corresponding to the positive. Generally, the positive level is the second (2)
since following an alpha-numeric order, the most common pairs are
\code{(Negative | Positive)}, \code{(0 | 1)}, \code{(FALSE | TRUE)}. Default : 2.}

\item{tidy}{Logical operator (TRUE/FALSE) to decide the type of return. TRUE
returns a data.frame, FALSE returns a list; Default : FALSE.}

\item{na.rm}{Logic argument to remove rows with missing values
(NA). Default is na.rm = TRUE.}
}
\value{
an object of class \code{numeric} within a \code{list} (if tidy = FALSE) or within a
\verb{data frame} (if tidy = TRUE).
}
\description{
\code{preval} estimates the prevalence of positive cases
for a nominal/categorical predicted-observed dataset.

\code{preval_t} estimates the prevalence threshold for a binary
predicted-observed dataset.
}
\details{
The prevalence measures the overall proportion of actual positives with
respect to the total number of observations. Currently, it is defined for binary cases only.

The general formula is:

\eqn{preval = \frac{positive}{positive + negative} }

The prevalence threshold represents an point on the ROC curve (function of
sensitivity (recall) and specificity) below which the precision (or PPV)
dramatically drops.

\eqn{preval_t = \frac{\sqrt{TPR * FPR} - FPR}{TPR - FPR} }

It is bounded between 0 and 1.
The closer to 1 the better. Values towards zero indicate low performance.
For the formula and more details, see
\href{https://adriancorrendo.github.io/metrica/articles/available_metrics_classification.html}{online-documentation}
}
\examples{
\donttest{
set.seed(123)
# Two-class
binomial_case <- data.frame(labels = sample(c("True","False"), 100, replace = TRUE), 
predictions = sample(c("True","False"), 100, replace = TRUE))
# Multi-class
multinomial_case <- data.frame(labels = sample(c("Red","Blue", "Green"), 100, replace = TRUE),
predictions = sample(c("Red","Blue", "Green"), 100, replace = TRUE)    )

# Get prevalence estimate for two-class case
preval(data = binomial_case, obs = labels, pred = predictions, tidy = TRUE)

# Get prevalence estimate for each class for the multi-class case
preval(data = multinomial_case, obs = labels, pred = predictions, atom = TRUE)

}
}
\references{
Freeman, E.A., Moisen, G.G. (2008).
A comparison of the performance of threshold criteria for binary classification in terms of predicted prevalence and kappa.
\emph{. Ecol. Modell. 217(1-2): 45-58.} \doi{10.1016/j.ecolmodel.2008.05.015}

Balayla, J. (2020).
Prevalence threshold and the geometry of screening curves.
_Plos one, 15(10):e0240215, _ \doi{10.1371/journal.pone.0240215}
}
