% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcolordwl.R
\name{p.col_ord_wl}
\alias{p.col_ord_wl}
\title{Ordered bar plot with legend}
\usage{
p.col_ord_wl(
  data,
  xaxis,
  yaxis,
  ybreaks = 10,
  percent = FALSE,
  dec = FALSE,
  yaccuracy = 0.01,
  ydecimalmark = ".",
  title = "Title",
  xlab = "X axis",
  ylab = "Y axis",
  stitle = NULL,
  note = NULL,
  ctitles = "black",
  cscales = ctitles,
  cbgrid = "white",
  clgrid = cbgrid,
  cplot = "white",
  cbserie = "black",
  cticks = "black",
  lwdserie = 1,
  legtitle = "Legend",
  legsize = 8,
  cleg = ctitles,
  legheight = 0.5,
  pnote = 1,
  cbord = cplot,
  titlesize = 20,
  wordssize = 12,
  snote = 11,
  legpos = "right",
  legdir = "horizontal",
  legcol = "white",
  legspa = 1,
  legvjust = 0.5,
  colors = grDevices::rainbow(length(xaxis), v = 0.7)
)
}
\arguments{
\item{data}{a dataframe}

\item{xaxis}{x axis data}

\item{yaxis}{y axis data}

\item{ybreaks}{number of y axis breaks (default=10)}

\item{percent}{If TRUE y axis in percent (default=F)}

\item{dec}{If TRUE serie come be decrescent,if FALSE crescent(default=F)}

\item{yaccuracy}{a round for y axis (default=0.01)}

\item{ydecimalmark}{y decimal mark (default=".")}

\item{title}{title of plot}

\item{xlab}{x axis label}

\item{ylab}{y axis label}

\item{stitle}{subtitle}

\item{note}{note}

\item{ctitles}{color of titles (title,xlab,ylab)}

\item{cscales}{color of the scales (default= same ctitles)}

\item{cbgrid}{color of grid background}

\item{clgrid}{color of grid lines}

\item{cplot}{color of plot background}

\item{cbserie}{color of serie border (default= same cserie)}

\item{cticks}{color of axis ticks}

\item{lwdserie}{size of serie}

\item{legtitle}{title of legend box}

\item{legsize}{size of legend}

\item{cleg}{color of legend words}

\item{legheight}{height of legend box}

\item{pnote}{position of note (default=1) (only numbers)}

\item{cbord}{color of plot border (default= same cplot)}

\item{titlesize}{size of title (default=20) (only numbers)}

\item{wordssize}{size of words (default=12) (only numbers)}

\item{snote}{size of note (default=11) (only numbers)}

\item{legpos}{legend position}

\item{legdir}{legend direction}

\item{legcol}{color of legend box}

\item{legspa}{spacement in legend box}

\item{legvjust}{vertical adjust in legend box}

\item{colors}{colors of bars, need same number of correspondencies.}
}
\value{
Return ordered bar plot with legend.
}
\description{
p.col_ord_wl make a ordered bar plot with legend.
}
\examples{
v=data.frame("x"=1:5,"y"=c(10,4,8,5,2))
p.col_ord_wl(v,xaxis= v$x,yaxis=v$y)
#or
p.col_ord_wl(v,xaxis= v[[1]],yaxis=v[[2]])

p.col_ord_wl(v,xaxis= v$x,yaxis=v$y,dec=TRUE,percent=FALSE)
p.col_ord_wl(v,xaxis= v$x,yaxis=v$y,dec=TRUE,percent=TRUE)
p.col_ord_wl(v,xaxis= v$x,yaxis=v$y,dec=FALSE,percent=FALSE)
p.col_ord_wl(v,xaxis= v$x,yaxis=v$y,dec=FALSE,percent=TRUE)

#Layout example
p.col_ord_wl(v,v$x,v$y,note = "metools - 2020",title = "Layout example",
stitle = "Ordered bar plot",ylab=NULL,wordssize = 10,titlesize = 32,
legspa = 0.5,legvjust = -2.5,legsize = 10,cplot='grey',
cbgrid="black",clgrid= "grey",ctitles = 'white',cleg = 'white',
legcol='black',colors=topo.colors(length(v$x),alpha=0.8))

}
