% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_evt.R
\name{calc_theta}
\alias{calc_theta}
\title{Potential temperature}
\usage{
calc_theta(t_fld, lev_p)
}
\arguments{
\item{t_fld}{temperature field [K]}

\item{lev_p}{vector containing pressure levels [Pa]}
}
\value{
density [kg/m^3]
}
\description{
Calculates the potential temperature
}
\examples{
myfile=system.file("extdata", "era5_storm-zeynep.nc", package = "meteoEVT")
data = readin_era5(myfile)
theta=calc_theta(data$temp,data$lev)
}
