% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_evt.R
\name{calc_bernoulli}
\alias{calc_bernoulli}
\title{Bernoulli function}
\usage{
calc_bernoulli(t_fld, u_fld, v_fld, w_fld, phi_fld)
}
\arguments{
\item{t_fld}{temperature field [K]}

\item{u_fld}{zonal velocity field [m/s]}

\item{v_fld}{meridional velocity field [m/s]}

\item{w_fld}{vertical velocity field [m/s]}

\item{phi_fld}{geopotential height [gpm]}
}
\value{
Bernoulli function field [m^2/s^2]
}
\description{
Calculates the Bernoulli function, i.e. total energy density, as sum of potential, kinetic and thermal energy density
}
\examples{
myfile=system.file("extdata", "era5_storm-zeynep.nc", package = "meteoEVT")
data = readin_era5(myfile)
bernoulli=calc_bernoulli(data$temp,data$u,data$v,data$w,data$z)
}
