% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/steps.R
\name{step_join}
\alias{step_join}
\title{Join external data into survey (step)}
\usage{
step_join(
  svy,
  x,
  by = NULL,
  type = c("left", "inner", "right", "full"),
  suffixes = c("", ".y"),
  .copy = use_copy_default(),
  comment = "Join step",
  use_copy = deprecated(),
  lazy = lazy_default(),
  record = TRUE
)
}
\arguments{
\item{svy}{A Survey or RotativePanelSurvey object.
If NULL, returns a step call}

\item{x}{A data.frame/data.table or a Survey to join into \code{svy}}

\item{by}{Character vector of join keys. Named vector for different names
between \code{svy} and \code{x} (names are keys in \code{svy},
values are keys in \code{x}).
If NULL, tries to infer common column names}

\item{type}{Join type: "left" (default), "inner", "right", or "full"}

\item{suffixes}{Length-2 character vector of suffixes
for conflicting columns
from \code{svy} and \code{x} respectively. Defaults to c("", ".y")}

\item{.copy}{Whether to operate on a copy (default: use_copy_default())}

\item{comment}{Optional description for the step (default \code{"Join step"}).}

\item{use_copy}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Use \code{.copy} instead.}

\item{lazy}{Internal. Whether to delay execution (default \code{lazy_default()}).}

\item{record}{Internal. Whether to record the step (default \code{TRUE}).}
}
\value{
Modified survey object with the join
recorded as a step (and applied immediately
when baked). For RotativePanelSurvey, the join is applied to
implantation and every follow_up survey.
}
\description{
Creates a step that joins additional data into a
Survey or RotativePanelSurvey.
}
\details{
\strong{Lazy evaluation (default):} By default, steps are recorded but
\strong{not executed} until \code{\link[=bake_steps]{bake_steps()}} is called.

Supports left, inner, right, and full joins. Allows named \code{by}
mapping (e.g., \code{c("id" = "code")}) or a simple character vector.
Conflicting column names are resolved by appending \code{suffixes}
to the right-hand side columns.
}
\examples{
# With data.frame
s <- Survey$new(
  data = data.table::data.table(id = 1:3, w = 1, a = c("x", "y", "z")),
  edition = "2023", type = "ech", psu = NULL, engine = "data.table",
  weight = add_weight(annual = "w")
)
info <- data.frame(id = c(1, 2), b = c(10, 20))
s2 <- step_join(s, info, by = "id", type = "left")
s2 <- bake_steps(s2)

# With another Survey
s_right <- Survey$new(
  data = data.table::data.table(id = c(2, 3), b = c(200, 300), w2 = 1),
  edition = "2023", type = "ech", psu = NULL, engine = "data.table",
  weight = add_weight(annual = "w2")
)
s3 <- step_join(s, s_right, by = c("id" = "id"), type = "inner")
s3 <- bake_steps(s3)

}
\seealso{
Other steps: 
\code{\link{bake_steps}()},
\code{\link{get_steps}()},
\code{\link{step_compute}()},
\code{\link{step_filter}()},
\code{\link{step_recode}()},
\code{\link{step_remove}()},
\code{\link{step_rename}()},
\code{\link{step_validate}()},
\code{\link{view_graph}()}
}
\concept{steps}
\keyword{step}
