% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/steps.R
\name{step_compute}
\alias{step_compute}
\title{Create computation steps for survey variables}
\usage{
step_compute(
  svy = NULL,
  ...,
  .by = NULL,
  .copy = use_copy_default(),
  comment = "Compute step",
  .level = "auto",
  use_copy = deprecated()
)
}
\arguments{
\item{svy}{A \code{Survey} or \code{RotativePanelSurvey} object.
If NULL, creates a step that can be applied later
using the pipe operator (\%>\%)}

\item{...}{Computation expressions with automatic
optimization. Names are assigned using
\code{new_var = expression}}

\item{.by}{Vector of variables to group computations
by. The system automatically validates these
variables exist before execution}

\item{.copy}{Logical indicating whether to create
a copy of the object before applying
transformations. Defaults to \code{use_copy_default()}}

\item{comment}{Descriptive text for the step for
documentation and traceability. Compatible with
Markdown syntax. Defaults to "Compute step"}

\item{.level}{For RotativePanelSurvey objects (default \code{"auto"}),
specifies the level where computations are
applied: \code{"implantation"}, \code{"follow_up"}, \code{"quarter"},
\code{"month"}, or \code{"auto"}}

\item{use_copy}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Use \code{.copy} instead.}
}
\value{
Same type of input object (\code{Survey} or \code{RotativePanelSurvey})
with new computed variables and the step added to the history
}
\description{
This function uses optimized expression evaluation
with automatic dependency detection and error
prevention. All computations are validated before
execution.
}
\details{
\strong{Lazy evaluation (default):} By default, steps are recorded but
\strong{not executed} until \code{\link[=bake_steps]{bake_steps()}} is called. This allows building
a full pipeline before materializing any changes. Set
\code{options(metasurvey.lazy_processing = FALSE)} to apply steps immediately.

\strong{Expression processing:}
Expressions are evaluated using data.table's \verb{:=} operator.
Variable dependencies are detected automatically via \code{all.vars()}.
Missing variables are caught before execution.

\strong{Grouped computations:} Use \code{.by} to compute aggregated values
(e.g., group means) that are automatically joined back to the data.

For RotativePanelSurvey objects, \code{.level} controls where computations
are applied:
\itemize{
\item \code{"auto"} (default): applies to both implantation and follow-ups
\item \code{"implantation"}: household/dwelling level only
\item \code{"follow_up"}: individual/person level only
}
}
\examples{
# Basic computation
dt <- data.table::data.table(
  id = 1:5, age = c(25, 30, 45, 50, 60), w = 1
)
svy <- Survey$new(
  data = dt, edition = "2023", type = "test",
  psu = NULL, engine = "data.table", weight = add_weight(annual = "w")
)
svy <- svy |> step_compute(age_squared = age^2, comment = "Age squared")
svy <- bake_steps(svy)
get_data(svy)

\donttest{
# ECH example: labor indicator
# ech <- ech |>
#   step_compute(
#     unemployed = ifelse(POBPCOAC \%in\% 3:5, 1, 0),
#     comment = "Unemployment indicator")
}
}
\seealso{
\code{\link{step_recode}} for categorical recodings
\code{\link{bake_steps}} to execute all pending steps

Other steps: 
\code{\link{bake_steps}()},
\code{\link{get_steps}()},
\code{\link{step_filter}()},
\code{\link{step_join}()},
\code{\link{step_recode}()},
\code{\link{step_remove}()},
\code{\link{step_rename}()},
\code{\link{step_validate}()},
\code{\link{view_graph}()}
}
\concept{steps}
\keyword{step}
