% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metaprotr_plot_stackedtaxo.R
\name{plot_stackedtaxo}
\alias{plot_stackedtaxo}
\title{plot_stackedtaxo}
\usage{
plot_stackedtaxo(
  spectral_count_object,
  target_variable,
  bars_data,
  filter_percent = 1,
  force = FALSE
)
}
\arguments{
\item{spectral_count_object}{List defined as "spectral_count_object" 
containing dataframes with spectral counts abundance organized by taxonomy 
(species, genus, family, order, class, phylum or superkingdom). This 
object is generated with the function "crumble_taxonomy".}

\item{target_variable}{Character indicating the name of one column from 
metadata. The stacked barplots will be ordered by the levels of this variable.}

\item{bars_data}{Character indicating the type of labels to be displayed in 
the stacked bars. The possible options are "percent" or "numbers".}

\item{filter_percent}{Optional numeric value between 0 and 99 that 
sets the minimal percentage of spectral counts at which the taxonomic 
elements will be displayed. The elements whose values are lower than 
this number will be gathered and displayed as "others". 
The default value is set at 1.}

\item{force}{Logic value set at FALSE by default in order to ask 
permission to create a pdf in the workstation of the user.}
}
\value{
Barplots (pdf) of the taxonomic distribution of the samples present 
   in a "spectral_count_object" with taxonomic levels.
}
\description{
Generates stacked barplots of the spectral counts distributions among the different
taxonomic entities ("species", "genus", "family", "order", "class", "phylum" 
or "superkingdom") within the samples or conditions of a "spectral_count_object" 
with taxonomy. If the provided conditions have several replicates 
the mean value is taken into account.
}
\examples{
\dontshow{.old_wd <- setwd(tempdir())}

data(species_fw)

plot_stackedtaxo(species_fw, 'SampleID', 'percent', 2)

plot_stackedtaxo(species_fw, 'SC_name', 'numbers')

\dontshow{setwd(.old_wd)}
}
