% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metaprotr_plot_intensities_ratio.R
\name{plot_intensities_ratio}
\alias{plot_intensities_ratio}
\title{plot_intensities_ratio}
\usage{
plot_intensities_ratio(
  spectral_count_object,
  target_variable,
  list_conditions,
  force = FALSE
)
}
\arguments{
\item{spectral_count_object}{List defined as "spectral_count_object" 
containing dataframes with abundance expressed as spectral counts
organized by peptides, subgroups, groups or taxonomic levels. 
The format of this object is similar to that generated from 
the functions "getsc_specific" and "crumble_taxonomy".}

\item{target_variable}{Character indicating the variable name 
containing the conditions to be compared. This value corresponds 
to the name of one column from metadata.}

\item{list_conditions}{Atomic vector indicating two conditions to A
be compared. The first element is considered as the reference (denominator) 
for ratio calculations.}

\item{force}{Logic value set at FALSE by default in order to ask 
permission to create object in the workstation of the user.}
}
\value{
A scatter plot (pdf) indicating the log2 (ratio + 1) of the entities
   (peptides, soubgroups, groups, taxonomic) between the two conditions provided.
}
\description{
Generates a scatter plot of the log2 (ratio + 1) between two conditions considering
the spectral counts of each entity (peptides, subgroups, groups or taxonomic 
levels) from a "spectral_count_object". If a given condition has several 
replicates the mean value is taken into account.
}
\examples{
\dontshow{.old_wd <- setwd(tempdir())}

data(fecal_waters)

plot_intensities_ratio(fecal_waters, "Methods", c("EF", "S"))

plot_intensities_ratio(fecal_waters, "SC_name", c("Q1", "Q2"))

\dontshow{setwd(.old_wd)}
}
