\name{mptrace}
\alias{mptrace}
\alias{mpbbox}
\alias{mpvp}
\title{
  Parse \command{mpost} Log Files
}
\description{
  Read a log file generated by \command{mpost} (possibly
  via \code{\link{mpost}}) to obtain solved MetaPost path information
  (which can then be drawn by \code{\link{grid.metapost}}).
}
\usage{
mptrace(logfile = "fig.log")
mpbbox(psfile)
mpvp(psfile, ...)
}
\arguments{
  \item{logfile}{
    The name of a log file generated by \command{mpost}.
  }
  \item{psfile}{
    The name of a PostScript files generated by \command{mpost}.
  }
  \item{...}{Arguments passed on to \code{viewport}.}
}
\details{
  The log file must have been generated by \command{mpost} with
  \code{tracingchoices=1}
  (possibly using \code{mpost(..., tracing=TRUE)}).

  The functions \code{mpbbox} and \code{mpvp} parse a PostScript
  file that was generated by \command{mpost}, returning the
  bounding box of the output and a viewport based on that bounding
  box respectively.
}
\value{
  A list of Bezier control points (\code{mpcontrols} objects).
}
\author{
  Paul Murrell
}
\seealso{
  \code{\link{mpost}},
  \code{\link{grid.metapost}}
}
\examples{
\donttest{
oldunits <- options(metapost.units="in")
oldwd <- setwd(tempdir())
p <- knot(0, 0) + dir(0) + dir(0) + knot(1, 1)
metapost(p, "fig.mp")
mpost("fig.mp")
paths <- mptrace("fig.log")
grid.metapost(paths)
setwd(oldwd)
options(oldunits)
}
}
\keyword{ dplot }% use one of  RShowDoc("KEYWORDS")
