% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ccalc.r
\name{ccalc}
\alias{ccalc}
\title{Calculate the concordance statistic}
\usage{
ccalc(
  cstat,
  cstat.se,
  cstat.cilb,
  cstat.ciub,
  cstat.cilv,
  sd.LP,
  N,
  O,
  Po,
  data,
  slab,
  subset,
  g = NULL,
  level = 0.95,
  approx.se.method = 4,
  ...
)
}
\arguments{
\item{cstat}{vector to specify the estimated c-statistics.}

\item{cstat.se}{Optional vector to specify the corresponding standard errors.}

\item{cstat.cilb}{Optional vector to specify the lower limits of the confidence interval.}

\item{cstat.ciub}{Optional vector to specify the upper limits of the confidence interval.}

\item{cstat.cilv}{Optional vector to specify the levels of aformentioned confidence interval limits. 
(default: 0.95, which corresponds to the 95\% confidence interval).}

\item{sd.LP}{Optional vector to specify the standard deviations of the linear predictor (prognostic index).}

\item{N}{Optional vector to specify the sample/group sizes.}

\item{O}{Optional vector to specify the total number of observed events.}

\item{Po}{Optional vector to specify the observed event probabilities.}

\item{data}{Optional data frame containing the variables given to the arguments above.}

\item{slab}{Optional vector with labels for the studies.}

\item{subset}{Optional vector indicating the subset of studies that should be used. This can be a logical vector or a numeric vector indicating the indices of the studies to include.}

\item{g}{a quoted string that is the function to transform estimates of the c-statistic; see the details below.}

\item{level}{Optional numeric to specify the level for the confidence interval, default \code{0.95}.}

\item{approx.se.method}{integer specifying which method should be used for estimating the standard error of the
c-statistic (Newcombe, 2006). So far, only method \code{2} and method \code{4} (default) have been implemented.}

\item{\ldots}{Additional arguments.}
}
\value{
An object of class c("mm_perf","data.frame") with the following columns:
\describe{
 \item{"theta"}{The (transformed) c-statistics. }
 \item{"theta.se"}{Standard errors of the (transformed) c-statistics.}
 \item{"theta.cilb"}{Lower confidence interval of the (transformed) c-statistics. The level is specified in
 \code{level}. Intervals are calculated on the same scale as \code{theta} by assuming a Normal distribution.}
 \item{"theta.ciub"}{Upper confidence interval of the (transformed) c-statistics. The level is specified in
 \code{level}. Intervals are calculated on the same scale as \code{theta} by assuming a Normal distribution.}
 \item{"theta.source"}{Method used for calculating the (transformed) c-statistic.}
 \item{"theta.se.source"}{Method used for calculating the standard error of the (transformed) c-statistic.}
}
}
\description{
The function calculates (transformed versions of) the concordance (c-)
statistic with the corresponding sampling variance.
}
\details{
The c-statistic is a measure of discrimination, and indicates the ability of a prediction model to 
distinguish between patients developing and not developing the outcome. The c-statistic typically ranges 
from 0.5 (no discriminative ability) to 1 (perfect discriminative ability). 

By default, the function \code{ccalc} will derive the c-statistic of each study, together with 
the corresponding standard error and 95\% confidence interval. However, it is also possible to calculate transformed 
versions of the c-statistic. Appropriate standard errors are then derived using the Delta method. 
For instance, the logit transformation can be applied by specifying \code{g="log(cstat/(1-cstat))"}. 

\subsection{Restoring the c-statistic}{
For studies where the c-statistic is missing, it is estimated from the standard deviation of the linear predictor 
(\code{theta.source="std.dev(LP)"}). The corresponding method is described by White et al. (2015).
}

\subsection{Restoring the standard error of the c-statistic}{
When missing, the standard error of the c-statistic can be estimated from the confidence interval. Alternatively, 
the standard error can be approximated from a combination of the reported c-statistic, the total sample size and 
the total number of events (Newcombe, 2006). This can be achieved by adopting (a modification of) the method 
proposed by Hanley and McNeil, as specified in \code{approx.se.method}.
}
}
\examples{
######### Validation of prediction models with a binary outcome #########
data(EuroSCORE)

# Calculate the c-statistic and its standard error
est1 <- ccalc(cstat = c.index, cstat.se = se.c.index, cstat.cilb = c.index.95CIl, 
              cstat.ciub = c.index.95CIu, N = n, O = n.events, data = EuroSCORE, slab = Study)
est1
  
# Calculate the logit c-statistic and its standard error
est2 <- ccalc(cstat = c.index, cstat.se = se.c.index, cstat.cilb = c.index.95CIl, 
              cstat.ciub = c.index.95CIu, N = n, O = n.events, data = EuroSCORE, slab = Study, 
              g = "log(cstat/(1-cstat))")
est2
      
# Display the results of all studies in a forest plot
plot(est1)
                                                            
}
\references{
Debray TPA, Damen JAAG, Snell KIE, Ensor J, Hooft L, Reitsma JB, et al. A guide to systematic review and meta-analysis of prediction model performance. BMJ. 2017;356:i6460. 

Debray TPA, Damen JAAG, Riley R, Snell KIE, Reitsma JB, Hooft L, et al. A framework for meta-analysis of  prediction model studies with binary and time-to-event outcomes. Stat Methods Med Res. 2018; In press. 

Hanley JA, McNeil BJ. The meaning and use of the area under a receiver operating characteristic (ROC) 
curve. \emph{Radiology}. 1982; 143(1):29--36.

Newcombe RG. Confidence intervals for an effect size measure based on the Mann-Whitney statistic. 
Part 2: asymptotic methods and evaluation. \emph{Stat Med}. 2006; 25(4):559--73.

Snell KI, Ensor J, Debray TP, Moons KG, Riley RD. Meta-analysis of prediction model performance across 
multiple studies: Which scale helps ensure between-study normality for the C -statistic and calibration measures? 
\emph{Statistical Methods in Medical Research}. 2017. 

White IR, Rapsomaniki E, the Emerging Risk Factors Collaboration. Covariate-adjusted measures of discrimination 
for survival data. \emph{Biom J}. 2015;57(4):592--613.
}
\author{
Thomas Debray <thomas.debray@gmail.com>
}
\keyword{concordance}
\keyword{discrimination}
\keyword{meta-analysis}
\keyword{performance}
\keyword{statistic}
