% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_sl.R
\name{meta_sl}
\alias{meta_sl}
\title{Create metadata for subject-level analysis table}
\usage{
meta_sl(
  dataset_population,
  dataset_observation = NULL,
  population_term,
  observation_term = NULL,
  parameter_term = "age;race;gender",
  parameter_var = "AGE^AGEGR1;RACE;SEX",
  parameter_labels = NULL,
  analysis_term = "base_char",
  analysis_title = "Participant Baseline Characteristics by Treatment Group",
  population_subset = SAFFL == "Y",
  observation_subset = NULL,
  population_label = "All Participants as Treated",
  treatment_group = "TRT01A"
)
}
\arguments{
\item{dataset_population}{Source dataset of population.}

\item{dataset_observation}{Source dataset of observation}

\item{population_term}{A character value of population term name.}

\item{observation_term}{A character value of observation term name.}

\item{parameter_term}{A character value of parameter term name.
If there are multiple terms, they are separated by the semicolon (;).}

\item{parameter_var}{A character value of parameter variable name.
If there are multiple variables, they are separated by the semicolon (;).
A group variable can be specified followed by a variable
and the hat symbol (^).}

\item{parameter_labels}{A character vector of parameter label name.
The length of vector should be the same as the number of parameter terms.
A label from an input data is used if \code{NA} for a variable is specified.}

\item{analysis_term}{A character value of analysis term name.}

\item{analysis_title}{A character value of analysis title name.}

\item{population_subset}{An unquoted condition for selecting the
populations from dataset of population.}

\item{observation_subset}{An unquoted condition for selecting the
populations from dataset of observation}

\item{population_label}{A character value of population label.}

\item{treatment_group}{A character value of treatment group name.}
}
\value{
A metalite object.
}
\description{
Create metadata for subject-level analysis table
}
\examples{
meta_sl(
  dataset_population = r2rtf::r2rtf_adsl,
  population_term = "apat",
  parameter_term = "age;race",
  parameter_var = "AGE^AGEGR1;RACE"
)
}
