% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_metabolic}
\alias{plot_metabolic}
\title{Plot results}
\usage{
plot_metabolic(x, save = FALSE, path, format = ".png")
}
\arguments{
\item{x}{an object obtained from the meta-analysis results. See 'Details'.}

\item{save}{A boolean to indicate whether to save the plot to disk.}

\item{path}{Path to write to. It has to be a character string indicating the path and file name (without the extension). For example, \verb{~/Documents/metabolic_gofer_page_1} will save \code{metabolic_gofer_page_1.png} to the \code{Documents} folder.}

\item{format}{The file extension that you want to save the plot to. Only \code{.png}, is supported.}
}
\value{
a plot.
}
\description{
Plot results from the \code{perform_meta()} and \code{perform_bind()} function. Please, see 'Details' and 'Examples'.
}
\details{
This function can be used to plot the results derived from both \code{perform_meta()} and \code{perform_bind()}. It can produce forests and bubble plots, depending on the object passed to the function.
}
\examples{
if(interactive()) {
# Perform meta-analysis on VO2max
results <- perform_meta(endpoint = "VO2max")

# Plot Overall meta-analysis results
results$meta_analysis$Overall \%>\%
   plot_metabolic()

# Plot Age meta-regression results
results$meta_regression$Age \%>\%
   plot_metabolic()

# Plot overview of Overall and Subgroups meta-analysis results
results_bind <- perform_bind(results$meta_analysis)
results_bind \%>\%
   plot_metabolic()

# Plot sensitivity analysis results
results$sensitivity_analysis$Overall \%>\%
   plot_metabolic()
}
}
