% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bracket.pairwise.R
\name{[.pairwise}
\alias{[.pairwise}
\alias{[,pairwise}
\title{Extract parts of pairwise object}
\usage{
\method{[}{pairwise}(x, ...)
}
\arguments{
\item{x}{An object of class \code{\link{pairwise}}.}

\item{\dots}{Additional arguments (passed on to [.data.frame).}
}
\description{
Auxiliary function to extract parts of \code{\link{pairwise}} object.
}
\examples{
# Transform data from arm-based format to contrast-based format
pw1 <- pairwise(list(Treatment1, Treatment2, Treatment3),
  n = list(n1, n2, n3),
  mean = list(y1, y2, y3), sd = list(sd1, sd2, sd3),
  data = dat.franchini2012, studlab = Study)

pw1[, 1:5]
pw1[!grepl("Lieberman", pw1$studlab), 1:5]

}
\seealso{
\code{\link{pairwise}}, \code{\link{subset.pairwise}},
  \code{\link[metadat]{dat.franchini2012}}
}
\author{
Guido Schwarzer \email{guido.schwarzer@uniklinik-freiburg.de}
}
