% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SE.R
\name{SE.SMD_from_OR.CI}
\alias{SE.SMD_from_OR.CI}
\title{Standard Error of from Confidence Intervals of Odds Ratio}
\usage{
SE.SMD_from_OR.CI(CI_low, CI_up, sig_level = 0.05, two_tailed = TRUE)
}
\arguments{
\item{CI_low}{lower odds ratio confidence interval limit}

\item{CI_up}{upper odds ratio confidence interval limit}

\item{sig_level}{the significance level}

\item{two_tailed}{whether the two-tailed or one-tailed z statistics should be calculated}
}
\value{
Standard Error
}
\description{
Calculates the standard error from an odds ratio confidence interval.
}
\details{
This method uses multiple steps in the background:
1 Takes odds ratio (OR) limits and transforms them to log(OR)
2 Calculates the standard error for the log(OR)
3 Transforms the log(OR) standard error to standardized mean differences (SMD) standard error by multiplying it with sqrt(3)/pi
}
\examples{
# lower CI = 0.6, upper CI = 0.9
SE.SMD_from_OR.CI(0.6, 0.9)
}
\references{
Chinn S. A simple method for converting an odds ratio to effect size for use in meta-analysis. Stat Med. 2000 Nov 30;19(22):3127-31. doi: 10.1002/1097-0258(20001130)
}
