% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphql-introspection.R
\name{meetupr_schema_mutations}
\alias{meetupr_schema_mutations}
\title{Explore available mutations in the Meetup GraphQL API}
\usage{
meetupr_schema_mutations(schema = meetupr_schema())
}
\arguments{
\item{schema}{The schema object obtained from \code{meetupr_schema()}.}
}
\value{
A tibble with details about each mutation, including:
\describe{
\item{field_name}{Name of the mutation}
\item{description}{Human-readable description}
\item{args_count}{Number of arguments the mutation accepts}
\item{return_type}{The GraphQL type returned after mutation}
}
If no mutations are available, returns a tibble with a message.
}
\description{
This function retrieves the mutation operations available in the Meetup
GraphQL API. Mutations are operations that modify data on the server (create,
update, delete).
}
\examples{
\dontrun{
# List all available mutations
mutations <- meetupr_schema_mutations()

# Check if mutations are supported
if (nrow(mutations) > 0 && !"message" \%in\% names(mutations)) {
  print(mutations$field_name)
}
}

}
