% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{meetupr_query}
\alias{meetupr_query}
\title{Execute GraphQL query}
\usage{
meetupr_query(graphql, ..., .envir = parent.frame())
}
\arguments{
\item{graphql}{GraphQL query string}

\item{...}{Variables to pass to query}

\item{.envir}{Environment for error handling}
}
\value{
The response from the GraphQL API as a list.
}
\description{
This function executes a GraphQL query with the provided variables.
It validates the variables, constructs the request,
and handles any errors returned by the GraphQL API.
}
\examples{
\dontrun{
query <- "
query GetUser($id: ID!) {
 user(id: $id) {
  id
 name
}
}"
meetupr_query(graphql = query, id = "12345")
}
}
